/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class BridgeHealth {
    private static Set<String> failures = new HashSet<String>();

    public static final double getDoubleOrInt(Object obj, String methodName, Throwable reason) {
        Object o1;
        String tag;
        if (reason != null && failures.add(tag = obj.getClass().getName() + "." + methodName)) {
            BridgeHealth.checkLogEntry(tag);
        }
        if ((o1 = ReflectionUtil.invokeMethodNoArgs(obj, methodName, Double.TYPE, Integer.TYPE)) instanceof Number) {
            return ((Number)o1).doubleValue();
        }
        String message = "Expect method " + methodName + " in " + obj.getClass() + " with return type double or int, returned instead: " + (o1 == null ? "null" : o1.getClass().getName());
        if (reason == null) {
            throw new RuntimeException(message);
        }
        throw new RuntimeException(message, reason);
    }

    public static double getAmount(EntityRegainHealthEvent event) {
        try {
            return event.getAmount();
        }
        catch (IncompatibleClassChangeError e) {
            return BridgeHealth.getDoubleOrInt(event, "getAmount", e);
        }
    }

    public static double getDamage(EntityDamageEvent event) {
        try {
            return event.getDamage();
        }
        catch (IncompatibleClassChangeError e) {
            return BridgeHealth.getDoubleOrInt(event, "getDamage", e);
        }
    }

    public static double getFinalDamage(EntityDamageEvent event) {
        try {
            return event.getFinalDamage();
        }
        catch (Throwable t) {
            return BridgeHealth.getDamage(event);
        }
    }

    public static void setDamage(EntityDamageEvent event, double damage) {
        try {
            event.setDamage(damage);
        }
        catch (IncompatibleClassChangeError e) {
            BridgeHealth.invokeVoid(event, "setDamage", (int)Math.round(damage), e);
        }
    }

    public static double getHealth(LivingEntity entity) {
        try {
            return entity.getHealth();
        }
        catch (IncompatibleClassChangeError e) {
            return BridgeHealth.getDoubleOrInt(entity, "getHealth", e);
        }
    }

    public static double getMaxHealth(LivingEntity entity) {
        try {
            return entity.getMaxHealth();
        }
        catch (IncompatibleClassChangeError e) {
            return BridgeHealth.getDoubleOrInt(entity, "getMaxHealth", e);
        }
    }

    public static double getLastDamage(LivingEntity entity) {
        try {
            return entity.getLastDamage();
        }
        catch (IncompatibleClassChangeError e) {
            return BridgeHealth.getDoubleOrInt(entity, "getLastDamage", e);
        }
    }

    public static void setHealth(LivingEntity entity, double health) {
        try {
            entity.setHealth(health);
        }
        catch (IncompatibleClassChangeError e) {
            BridgeHealth.invokeVoid(entity, "setHealth", (int)Math.round(health), e);
        }
    }

    public static void damage(LivingEntity entity, double damage) {
        try {
            entity.damage(damage);
        }
        catch (IncompatibleClassChangeError e) {
            BridgeHealth.invokeVoid(entity, "damage", (int)Math.round(damage), e);
        }
    }

    public static EntityDamageEvent getEntityDamageEvent(Entity entity, EntityDamageEvent.DamageCause damageCause, double damage) {
        try {
            return new EntityDamageEvent(entity, damageCause, damage);
        }
        catch (IncompatibleClassChangeError e) {
            return new EntityDamageEvent(entity, damageCause, (int)Math.round(damage));
        }
    }

    public static void invokeVoid(Object obj, String methodName, int value, Throwable reason) {
        String tag;
        if (reason != null && failures.add(tag = obj.getClass().getName() + "." + methodName)) {
            BridgeHealth.checkLogEntry(tag);
        }
        try {
            obj.getClass().getMethod(methodName, Integer.TYPE).invoke(obj, value);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not invoke " + methodName + " with one argument (int) on: " + obj.getClass().getName(), reason);
        }
    }

    private static void checkLogEntry(String tag) {
        if (ConfigManager.getConfigFile().getBoolean("logging.extended.status")) {
            StaticLog.logInfo("[NoCheatPlus] Try old health API: " + tag);
        }
    }
}

