/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommand<A>
implements TabExecutor {
    public static final List<String> noTabChoices = Collections.unmodifiableList(new LinkedList());
    protected final A access;
    public final String label;
    public final String permission;
    protected final Map<String, AbstractCommand<?>> subCommands = new LinkedHashMap();
    protected int subCommandIndex = -1;
    protected final String[] aliases;
    protected String usage = null;

    public static String join(String[] args, int startIndex) {
        return AbstractCommand.join(args, startIndex, " ");
    }

    public static String join(String[] args, int startIndex, String sep) {
        StringBuilder b = new StringBuilder(100);
        if (startIndex < args.length) {
            b.append(args[startIndex]);
        }
        for (int i = startIndex + 1; i < args.length; ++i) {
            b.append(sep);
            b.append(args[i]);
        }
        return b.toString();
    }

    public static boolean demandPlayer(CommandSender sender) {
        if (sender instanceof Player) {
            return true;
        }
        sender.sendMessage("[NoCheatPlus] A player is required to run this command.");
        return false;
    }

    public static boolean demandConsoleCommandSender(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        sender.sendMessage("[NoCheatPlus] This command can only be run from the console.");
        return false;
    }

    public AbstractCommand(A access, String label, String permission) {
        this(access, label, permission, null);
    }

    public AbstractCommand(A access, String label, String permission, String[] aliases) {
        this.access = access;
        this.label = label;
        this.permission = permission;
        this.aliases = aliases;
    }

    public void addSubCommands(AbstractCommand<?> ... commands) {
        for (AbstractCommand<?> subCommand : commands) {
            this.subCommands.put(subCommand.label, subCommand);
            if (subCommand.subCommandIndex == -1) {
                subCommand.subCommandIndex = Math.max(0, this.subCommandIndex) + 1;
            }
            if (subCommand.aliases == null) continue;
            for (String alias : subCommand.aliases) {
                if (this.subCommands.containsKey(alias)) continue;
                this.subCommands.put(alias, subCommand);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String arg;
        AbstractCommand<?> subCommand;
        LinkedHashSet<String> choices = new LinkedHashSet<String>(this.subCommands.size());
        int len = args.length;
        int subCommandIndex = Math.max(0, this.subCommandIndex);
        if (len == subCommandIndex || len == subCommandIndex + 1) {
            String arg2 = len == subCommandIndex ? "" : args[subCommandIndex].trim().toLowerCase();
            for (AbstractCommand<?> cmd : this.subCommands.values()) {
                if (!cmd.label.startsWith(arg2) || !cmd.testPermission(sender, command, alias, args)) continue;
                choices.add(cmd.label);
            }
        } else if (len > subCommandIndex + 1 && (subCommand = this.subCommands.get(arg = args[subCommandIndex].trim().toLowerCase())) != null && subCommand.testPermission(sender, command, alias, args)) {
            return subCommand.onTabComplete(sender, command, alias, args);
        }
        if (choices.isEmpty()) {
            return noTabChoices;
        }
        return new LinkedList<String>(choices);
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        String arg;
        AbstractCommand<?> subCommand;
        int len = args.length;
        int subCommandIndex = Math.max(0, this.subCommandIndex);
        if (len > subCommandIndex && (subCommand = this.subCommands.get(arg = args[subCommandIndex].trim().toLowerCase())) != null) {
            if (!subCommand.testPermission(sender, command, alias, args)) {
                sender.sendMessage(ChatColor.DARK_RED + "You don't have permission.");
                return true;
            }
            boolean res = subCommand.onCommand(sender, command, alias, args);
            if (!res && subCommand.usage != null) {
                sender.sendMessage(subCommand.usage);
                return true;
            }
            return res;
        }
        return false;
    }

    public boolean testPermission(CommandSender sender, Command command, String alias, String[] args) {
        return this.permission == null || sender.hasPermission(this.permission);
    }
}

