/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FlyingFrequency
extends BaseAdapter {
    public static final int numBooleans = 3;
    public static final int indexOnGround = 0;
    public static final int indexhasPos = 1;
    public static final int indexhasLook = 2;
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    public static final double minMoveDistSq = 0.00390625;
    public static final float minLookChange = 10.0f;
    private final Check frequency = new Check(CheckType.NET_FLYINGFREQUENCY){};
    private final int idHandled = this.counters.registerKey("packet.flying.handled");
    private final int idAsyncFlying = this.counters.registerKey("packet.flying.asynchronous");
    private boolean packetMismatch = false;

    public FlyingFrequency(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, PacketType.Play.Client.FLYING, PacketType.Play.Client.LOOK, PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK);
    }

    public void onPacketReceiving(PacketEvent event) {
        DataPacketFlying packetData;
        boolean primaryThread;
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            event.setCancelled(true);
            return;
        }
        NetConfig cc = (NetConfig)this.configFactory.getConfig(player.getWorld());
        if (!cc.flyingFrequencyActive) {
            return;
        }
        this.counters.add(this.idHandled, 1);
        NetData data = this.dataFactory.getData(player);
        data.lastKeepAliveTime = time;
        boolean bl = primaryThread = !event.isAsync();
        if (!primaryThread) {
            this.counters.addSynchronized(this.idAsyncFlying, 1);
        }
        DataPacketFlying dataPacketFlying = packetData = this.packetMismatch ? null : this.interpretPacket(event, time);
        if (packetData != null) {
            if (this.isInvalidContent(packetData)) {
                event.setCancelled(true);
                if (data.debug) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " sends a flying packet with malicious content.");
                }
                return;
            }
            if (cc.flyingFrequencyStrayPacketsCancel) {
                switch (data.teleportQueue.processAck(packetData)) {
                    case CANCEL: {
                        event.setCancelled(true);
                        if (data.debug) {
                            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " wait for ACK on teleport, cancel packet: " + packetData);
                        }
                        return;
                    }
                    case ACK: {
                        if (data.debug) {
                            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " interpret as ACK for a teleport: " + packetData);
                        }
                        return;
                    }
                }
            }
        }
        data.flyingFrequencyAll.add(time, 1.0f);
        float allScore = data.flyingFrequencyAll.score(1.0f);
        if ((double)(allScore / (float)cc.flyingFrequencySeconds) > cc.flyingFrequencyPPS && !this.frequency.hasBypass(player) && this.frequency.executeActions(player, (double)(allScore / (float)cc.flyingFrequencySeconds) - cc.flyingFrequencyPPS, 1.0 / (double)cc.flyingFrequencySeconds, cc.flyingFrequencyActions)) {
            event.setCancelled(true);
            return;
        }
        if (data.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " " + packetData + (event.isCancelled() ? " CANCEL" : ""));
        }
    }

    private boolean isInvalidContent(DataPacketFlying packetData) {
        if (packetData.hasPos && CheckUtils.isBadCoordinate(packetData.x, packetData.y, packetData.z)) {
            return true;
        }
        return packetData.hasLook && CheckUtils.isBadCoordinate(packetData.yaw, packetData.pitch);
    }

    private DataPacketFlying interpretPacket(PacketEvent event, long time) {
        List floats;
        List doubles;
        PacketContainer packet = event.getPacket();
        List booleans = packet.getBooleans().getValues();
        if (booleans.size() != 3) {
            this.packetMismatch();
            return null;
        }
        boolean hasPos = (Boolean)booleans.get(1);
        boolean hasLook = (Boolean)booleans.get(2);
        boolean onGround = (Boolean)booleans.get(0);
        if (!hasPos && !hasLook) {
            return new DataPacketFlying(onGround, time);
        }
        if (hasPos) {
            doubles = packet.getDoubles().getValues();
            if (doubles.size() != 3) {
                this.packetMismatch();
                return null;
            }
        } else {
            doubles = null;
        }
        if (hasLook) {
            floats = packet.getFloat().getValues();
            if (floats.size() != 2) {
                this.packetMismatch();
                return null;
            }
        } else {
            floats = null;
        }
        if (hasPos && hasLook) {
            return new DataPacketFlying(onGround, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasLook) {
            return new DataPacketFlying(onGround, ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasPos) {
            return new DataPacketFlying(onGround, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), time);
        }
        throw new IllegalStateException("Can't be, it can't be!");
    }

    private boolean checkRedundantPackets(Player player, DataPacketFlying packetData, float allScore, long time, NetData data, NetConfig cc) {
        MovingData mData = MovingData.getData(player);
        if (mData.toX == Double.MAX_VALUE && mData.toYaw == Float.MAX_VALUE) {
            return false;
        }
        boolean onGroundSkip = false;
        if (packetData.onGround != data.flyingFrequencyOnGround) {
            long lastTime;
            if (packetData.onGround) {
                lastTime = data.flyingFrequencyTimeOnGround;
                data.flyingFrequencyTimeOnGround = time;
            } else {
                lastTime = data.flyingFrequencyTimeNotOnGround;
                data.flyingFrequencyTimeNotOnGround = time;
            }
            if (time < lastTime || time - lastTime > 1000L) {
                onGroundSkip = true;
            }
        }
        data.flyingFrequencyOnGround = packetData.onGround;
        if (packetData.hasPos && TrigUtil.distanceSquared(packetData.x, packetData.y, packetData.z, mData.toX, mData.toY, mData.toZ) > 0.00390625) {
            return false;
        }
        if (packetData.hasLook && (Math.abs(TrigUtil.yawDiff(packetData.yaw, mData.toYaw)) > 10.0f || Math.abs(TrigUtil.yawDiff(packetData.pitch, mData.toPitch)) > 10.0f)) {
            return false;
        }
        if (onGroundSkip) {
            return false;
        }
        if (allScore / (float)cc.flyingFrequencySeconds > 20.0f && !this.frequency.hasBypass(player)) {
            data.flyingFrequencyRedundantFreq.add(time, 1.0f);
            if (this.frequency.executeActions(player, data.flyingFrequencyRedundantFreq.score(1.0f) / (float)cc.flyingFrequencyRedundantSeconds, 1.0 / (double)cc.flyingFrequencyRedundantSeconds, cc.flyingFrequencyRedundantActions)) {
                return true;
            }
        }
        return false;
    }

    private void packetMismatch() {
        this.packetMismatch = true;
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "[NoCheatPlus] Data mismatch: disable interpretation of flying packets.");
    }
}

