/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;

public class NetConfig
extends ACheckConfig {
    public final boolean flyingFrequencyActive;
    public final int flyingFrequencySeconds;
    public final double flyingFrequencyPPS;
    public final ActionList flyingFrequencyActions;
    public final boolean flyingFrequencyStrayPacketsCancel;
    public final boolean flyingFrequencyRedundantActive;
    public final int flyingFrequencyRedundantSeconds;
    public final ActionList flyingFrequencyRedundantActions;
    public final boolean keepAliveFrequencyActive;
    public final ActionList keepAliveFrequencyActions;
    public final boolean soundDistanceActive;
    public final double soundDistanceSq;

    public NetConfig(ConfigFile config) {
        super(config, "checks.net.", new String[]{"nocheatplus.checks.net.flyingfrequency", "nocheatplus.checks.net.keepalivefrequency"});
        ConfigFile globalConfig = ConfigManager.getConfigFile();
        this.flyingFrequencyActive = config.getBoolean("checks.net.flyingfrequency.active");
        this.flyingFrequencySeconds = Math.max(1, globalConfig.getInt("checks.net.flyingfrequency.seconds"));
        this.flyingFrequencyPPS = Math.max(1.0, globalConfig.getDouble("checks.net.flyingfrequency.packetspersecond"));
        this.flyingFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.flyingfrequency.actions", "nocheatplus.checks.net.flyingfrequency");
        this.flyingFrequencyStrayPacketsCancel = config.getBoolean("checks.net.flyingfrequency.straypackets.cancel");
        this.flyingFrequencyRedundantActive = config.getBoolean("checks.net.flyingfrequency.cancelredundant");
        this.flyingFrequencyRedundantSeconds = Math.max(1, config.getInt("checks.net.flyingfrequency.reduceredundant.seconds"));
        this.flyingFrequencyRedundantActions = (ActionList)config.getOptimizedActionList("checks.net.flyingfrequency.reduceredundant.actions", "nocheatplus.checks.net.flyingfrequency");
        this.keepAliveFrequencyActive = config.getBoolean("checks.net.keepalivefrequency.active");
        this.keepAliveFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.keepalivefrequency.actions", "nocheatplus.checks.net.keepalivefrequency");
        this.soundDistanceActive = config.getBoolean("checks.net.sounddistance.active");
        double dist = config.getDouble("checks.net.sounddistance.maxdistance");
        this.soundDistanceSq = dist * dist;
    }

    public boolean isEnabled(CheckType checkType) {
        switch (checkType) {
            case NET_FLYINGFREQUENCY: {
                return this.flyingFrequencyActive;
            }
            case NET_SOUNDDISTANCE: {
                return this.soundDistanceActive;
            }
            case NET_KEEPALIVEFREQUENCY: {
                return this.keepAliveFrequencyActive;
            }
        }
        return true;
    }
}

