/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LiftOffEnvelope {
    NORMAL(0.42, 1.35, 6, true),
    LIMIT_NEAR_GROUND(0.42, 1.35, 6, false),
    LIMIT_LIQUID(0.1, 0.27, 3, false),
    NO_JUMP(0.0, 0.0, 0, false);

    private double maxJumpGain;
    private double maxJumpHeight;
    private int maxJumpPhase;
    private boolean jumpEffectApplies;

    private LiftOffEnvelope(double maxJumpGain, double maxJumpHeight, int maxJumpPhase, boolean jumpEffectApplies) {
        this.maxJumpGain = maxJumpGain;
        this.maxJumpHeight = maxJumpHeight;
        this.maxJumpPhase = maxJumpPhase;
        this.jumpEffectApplies = jumpEffectApplies;
    }

    public double getMaxJumpGain(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier != 0.0) {
            return Math.max(0.0, this.maxJumpGain + 0.2 * jumpAmplifier);
        }
        return this.maxJumpGain;
    }

    public double getMaxJumpHeight(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier > 0.0) {
            if (jumpAmplifier < 10.0) {
                return this.maxJumpHeight + 0.6 + jumpAmplifier - 1.0;
            }
            if (jumpAmplifier < 19.0) {
                return 0.6 + (jumpAmplifier + 3.2) * (jumpAmplifier + 3.2) / 16.0;
            }
            return 0.6 + (jumpAmplifier + 3.2) * (jumpAmplifier + 3.2) / 16.0 - jumpAmplifier * (jumpAmplifier - 1.0) / 2.0 * 0.03125;
        }
        return this.maxJumpHeight;
    }

    public int getMaxJumpPhase(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier > 0.0) {
            return (int)Math.round((0.5 + jumpAmplifier) * (double)this.maxJumpPhase);
        }
        return this.maxJumpPhase;
    }

    public boolean jumpEffectApplies() {
        return this.jumpEffectApplies;
    }
}

