/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.locations.LocUtil;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Passable
extends Check {
    private final PassableRayTracing rayTracing = new PassableRayTracing();

    public Passable() {
        super(CheckType.MOVING_PASSABLE);
        this.rayTracing.setMaxSteps(60);
    }

    public Location check(Player player, Location loc, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        boolean toPassable;
        String tags = "";
        int manhattan = from.manhattan(to);
        if (manhattan <= 1 && BlockProperties.isPassable(from.getTypeId())) {
            if (manhattan == 0) {
                return null;
            }
            if (BlockProperties.isPassable(to.getTypeId())) {
                return null;
            }
        }
        if ((toPassable = to.isPassable()) && cc.passableRayTracingCheck && (!cc.passableRayTracingBlockChangeOnly || manhattan > 0)) {
            this.rayTracing.set(from, to);
            this.rayTracing.loop();
            if (this.rayTracing.collides() || this.rayTracing.getStepsDone() >= this.rayTracing.getMaxSteps()) {
                int maxBlockDist;
                int n = maxBlockDist = manhattan <= 1 ? manhattan : from.maxBlockDist(to);
                if (maxBlockDist <= 1 && this.rayTracing.getStepsDone() == 1 && !from.isPassable()) {
                    if (this.collidesIgnoreFirst(from, to)) {
                        toPassable = false;
                        tags = "raytracing_2x_";
                    } else if (data.debug) {
                        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " passable: allow moving out of a block.");
                    }
                } else if (!this.allowsSplitMove(from, to, manhattan)) {
                    toPassable = false;
                    tags = "raytracing_";
                }
            }
            this.rayTracing.cleanup();
        }
        if (toPassable) {
            data.passableVL *= 0.99;
            return null;
        }
        return this.potentialViolation(player, loc, from, to, manhattan, tags, data, cc);
    }

    private Location potentialViolation(Player player, Location loc, PlayerLocation from, PlayerLocation to, int manhattan, String tags, MovingData data, MovingConfig cc) {
        int lbX = loc.getBlockX();
        int lbY = loc.getBlockY();
        int lbZ = loc.getBlockZ();
        Location setBackLoc = null;
        if (from.isPassable()) {
            if (from.isBlockAbove(to) && (BlockProperties.getBlockFlags(to.getTypeId()) & 0x40L) != 0L && BlockProperties.collidesBlock(to.getBlockCache(), from.getX(), from.getY(), from.getZ(), from.getX(), from.getY(), from.getZ(), to.getBlockX(), to.getBlockY(), to.getBlockZ(), to.getTypeId())) {
                return null;
            }
            tags = tags + "into";
        } else if (BlockProperties.isPassable(from.getBlockCache(), loc.getX(), loc.getY(), loc.getZ(), from.getTypeId(lbX, lbY, lbZ))) {
            tags = tags + "into_shift";
            setBackLoc = loc;
        } else if (!from.isSameBlock(lbX, lbY, lbZ)) {
            tags = tags + "cross_shift";
        } else {
            if (manhattan == 1 && to.isBlockAbove(from) && BlockProperties.isPassable(from.getBlockCache(), from.getX(), from.getY() + player.getEyeHeight(), from.getZ(), from.getTypeId(from.getBlockX(), Location.locToBlock((double)(from.getY() + player.getEyeHeight())), from.getBlockZ()))) {
                return null;
            }
            if (manhattan > 0) {
                tags = tags + "cross";
            } else {
                return null;
            }
        }
        if (setBackLoc != null && (TrigUtil.distance(from, to) > 0.75 || TrigUtil.distance(from, setBackLoc) > 0.125)) {
            setBackLoc = null;
        }
        if (data.hasSetBack()) {
            Location ref = data.getSetBack(to);
            if (BlockProperties.isPassable(from.getBlockCache(), ref) || setBackLoc == null || TrigUtil.distance(from, setBackLoc) > 0.13) {
                setBackLoc = ref;
                if (data.debug) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Using set-back location for passable.");
                }
            } else if (data.debug) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Ignoring set-back for passable.");
            }
        }
        data.passableVL += 1.0;
        ViolationData vd = new ViolationData(this, player, data.passableVL, 1.0, cc.passableActions);
        if (data.debug || vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
            vd.setParameter(ParameterName.BLOCK_ID, "" + to.getTypeId());
            if (!tags.isEmpty()) {
                vd.setParameter(ParameterName.TAGS, tags);
            }
        }
        if (this.executeActions(vd)) {
            Location newTo;
            if (setBackLoc != null) {
                newTo = LocUtil.clone(setBackLoc);
            } else {
                newTo = from.getLocation();
                if (data.debug) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " Using from location for passable.");
                }
            }
            newTo.setYaw(to.getYaw());
            newTo.setPitch(to.getPitch());
            return newTo;
        }
        return null;
    }

    private boolean collidesIgnoreFirst(PlayerLocation from, PlayerLocation to) {
        this.rayTracing.set(from, to);
        this.rayTracing.setIgnorefirst();
        this.rayTracing.loop();
        return this.rayTracing.collides() || this.rayTracing.getStepsDone() >= this.rayTracing.getMaxSteps();
    }

    private boolean allowsSplitMove(PlayerLocation from, PlayerLocation to, int manhattan) {
        double yDiff = to.getY() - from.getY();
        if (manhattan <= 3 && yDiff > 0.0 && Math.abs(yDiff) < 1.0) {
            if (yDiff > 0.0) {
                this.rayTracing.set(from.getX(), from.getY(), from.getZ(), from.getX(), to.getY(), from.getZ());
                this.rayTracing.loop();
                if (!this.rayTracing.collides()) {
                    this.rayTracing.set(from.getX(), to.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
                    this.rayTracing.loop();
                    if (!this.rayTracing.collides()) {
                        return true;
                    }
                }
            } else {
                this.rayTracing.set(from.getX(), from.getY(), from.getZ(), to.getX(), from.getY(), to.getZ());
                this.rayTracing.loop();
                if (!this.rayTracing.collides()) {
                    this.rayTracing.set(to.getX(), from.getY(), to.getZ(), to.getX(), to.getY(), to.getZ());
                    this.rayTracing.loop();
                    if (!this.rayTracing.collides()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

