/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.access.CheckDataFactory;
import fr.neatmonster.nocheatplus.checks.access.ICheckData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.locations.LocUtil;
import fr.neatmonster.nocheatplus.checks.moving.locations.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.velocity.AccountEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.FrictionAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ActionAccumulator;
import fr.neatmonster.nocheatplus.utilities.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class MovingData
extends ACheckData {
    public static final CheckDataFactory factory = new CheckDataFactory(){

        public final ICheckData getData(Player player) {
            return MovingData.getData(player);
        }

        public ICheckData removeData(String playerName) {
            return MovingData.removeData(playerName);
        }

        public void removeAllData() {
            MovingData.clear();
        }
    };
    private static Map<String, MovingData> playersMap = new HashMap<String, MovingData>();
    private static final LiftOffEnvelope defaultLiftOffEnvelope = LiftOffEnvelope.NO_JUMP;
    private static final double TOL_VVEL = 0.0625;
    public double creativeFlyVL = 0.0;
    public double morePacketsVL = 0.0;
    public double morePacketsVehicleVL = 0.0;
    public double noFallVL = 0.0;
    public double survivalFlyVL = 0.0;
    public int bunnyhopDelay;
    public double jumpAmplifier = 0.0;
    public long timeSprinting = 0L;
    public double multSprinting = 1.30000002;
    public double lastYDist = Double.MAX_VALUE;
    public double lastHDist = Double.MAX_VALUE;
    public SimpleEntry verVelUsed = null;
    public int speedTick = 0;
    public float walkSpeed = 0.0f;
    public float flySpeed = 0.0f;
    private final SimpleAxisVelocity verVel = new SimpleAxisVelocity();
    private final FrictionAxisVelocity horVel = new FrictionAxisVelocity();
    public double fromX = Double.MAX_VALUE;
    public double fromY;
    public double fromZ;
    public double toX = Double.MAX_VALUE;
    public double toY;
    public double toZ;
    public float toYaw = Float.MAX_VALUE;
    public float toPitch;
    private LocationTrace trace = null;
    public boolean toWasReset;
    public boolean fromWasReset;
    public LiftOffEnvelope liftOffEnvelope = defaultLiftOffEnvelope;
    private Location setBack = null;
    private Location teleported = null;
    public boolean creativeFlyPreviousRefused;
    public final ActionFrequency morePacketsFreq;
    public final ActionFrequency morePacketsBurstFreq;
    private Location morePacketsSetback = null;
    public int morePacketsVehicleBuffer = 50;
    public long morePacketsVehicleLastTime;
    private Location morePacketsVehicleSetback = null;
    public int morePacketsVehicleTaskId = -1;
    public float noFallFallDistance = 0.0f;
    public double noFallMaxY = 0.0;
    public boolean noFallAssumeGround = false;
    public boolean noFallSkipAirCheck = false;
    public double passableVL;
    public double sfHorizontalBuffer = 0.0;
    public int lostSprintCount = 0;
    public int sfJumpPhase = 0;
    private boolean sfDirty = false;
    public boolean sfLowJump = false;
    public boolean sfNoLowJump = false;
    public int sfHoverTicks = -1;
    public int sfHoverLoginTicks = 0;
    public int sfOnIce = 0;
    public long sfCobwebTime = 0L;
    public double sfCobwebVL = 0.0;
    public long sfVLTime = 0L;
    public final ActionAccumulator vDistAcc = new ActionAccumulator(3, 3);
    public double lastFrictionHorizontal = 0.0;
    public double lastFrictionVertical = 0.0;
    public double nextFrictionHorizontal = 0.0;
    public double nextFrictionVertical = 0.0;
    public boolean wasInVehicle = false;
    public MoveConsistency vehicleConsistency = MoveConsistency.INCONSISTENT;
    public boolean joinOrRespawn = false;

    public static MovingData getData(Player player) {
        MovingData data = playersMap.get(player.getName());
        if (data == null) {
            data = new MovingData(MovingConfig.getConfig(player));
            playersMap.put(player.getName(), data);
        }
        return data;
    }

    public static ICheckData removeData(String playerName) {
        return playersMap.remove(playerName);
    }

    public static void clear() {
        playersMap.clear();
    }

    public static void onWorldUnload(World world) {
        String worldName = world.getName();
        for (MovingData data : playersMap.values()) {
            data.onWorldUnload(worldName);
        }
    }

    public static void onReload() {
        for (MovingData data : playersMap.values()) {
            data.deleteTrace();
        }
    }

    public MovingData(MovingConfig config) {
        super(config);
        this.morePacketsFreq = new ActionFrequency(config.morePacketsEPSBuckets, 500L);
        this.morePacketsBurstFreq = new ActionFrequency(12, 5000L);
    }

    public void clearFlyData() {
        this.bunnyhopDelay = 0;
        this.sfJumpPhase = 0;
        this.jumpAmplifier = 0.0;
        this.setBack = null;
        this.lastHDist = Double.MAX_VALUE;
        this.lastYDist = Double.MAX_VALUE;
        this.toX = Double.MAX_VALUE;
        this.fromX = Double.MAX_VALUE;
        this.toYaw = Float.MAX_VALUE;
        this.clearAccounting();
        this.clearNoFallData();
        this.removeAllVelocity();
        this.sfHorizontalBuffer = 0.0;
        this.lostSprintCount = 0;
        this.fromWasReset = false;
        this.toWasReset = false;
        this.sfHoverLoginTicks = -1;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
        this.verVelUsed = null;
    }

    public void onSetBack(Location setBack) {
        this.resetPositions(this.teleported);
        this.setSetBack(this.teleported);
        this.morePacketsVehicleSetback = null;
        this.morePacketsSetback = null;
        this.clearAccounting();
        this.sfHorizontalBuffer = 0.0;
        this.lostSprintCount = 0;
        this.fromWasReset = false;
        this.toWasReset = false;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.removeAllVelocity();
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
    }

    public void prepareSetBack(Location loc) {
        this.clearAccounting();
        this.sfJumpPhase = 0;
        this.lastHDist = Double.MAX_VALUE;
        this.lastYDist = Double.MAX_VALUE;
        this.toWasReset = false;
        this.fromWasReset = false;
        this.setTeleported(loc);
    }

    public void resetPositions(Location loc) {
        if (loc == null) {
            this.resetPositions();
        } else {
            this.resetPositions(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        }
    }

    public void resetPositions(PlayerLocation loc) {
        if (loc == null) {
            this.resetPositions();
        } else {
            this.resetPositions(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        }
    }

    public void resetPositions() {
        this.resetPositions(Double.MAX_VALUE, 0.0, 0.0, Float.MAX_VALUE, 0.0f);
    }

    public void resetPositions(double x, double y, double z, float yaw, float pitch) {
        this.fromX = this.toX = x;
        this.fromY = this.toY = y;
        this.fromZ = this.toZ = z;
        this.toYaw = yaw;
        this.toPitch = pitch;
        this.lastHDist = Double.MAX_VALUE;
        this.lastYDist = Double.MAX_VALUE;
        this.sfDirty = false;
        this.sfLowJump = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.lastFrictionVertical = 0.0;
        this.lastFrictionHorizontal = 0.0;
    }

    public void resetLastDistances() {
        this.lastYDist = Double.MAX_VALUE;
        this.lastHDist = Double.MAX_VALUE;
    }

    public void setPositions(Location from, Location to) {
        this.fromX = from.getX();
        this.fromY = from.getY();
        this.fromZ = from.getZ();
        this.toX = to.getX();
        this.toY = to.getY();
        this.toZ = to.getZ();
        this.toYaw = to.getYaw();
        this.toPitch = to.getPitch();
    }

    public void clearAccounting() {
        this.vDistAcc.clear();
    }

    public void clearMorePacketsData() {
        this.morePacketsSetback = null;
        this.morePacketsVehicleSetback = null;
    }

    public void clearNoFallData() {
        this.noFallFallDistance = 0.0f;
        this.noFallMaxY = 0.0;
        this.noFallSkipAirCheck = false;
    }

    public void setSetBack(PlayerLocation loc) {
        if (this.setBack == null) {
            this.setBack = loc.getLocation();
        } else {
            LocUtil.set(this.setBack, loc);
        }
    }

    public void setSetBack(Location loc) {
        if (this.setBack == null) {
            this.setBack = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.setBack, loc);
        }
    }

    public Location getSetBack(Location ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public Location getSetBack(PlayerLocation ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public boolean hasSetBack() {
        return this.setBack != null;
    }

    public boolean hasSetBackWorldChanged(Location loc) {
        if (this.setBack == null) {
            return true;
        }
        return this.setBack.getWorld().equals(loc.getWorld());
    }

    public double getSetBackX() {
        return this.setBack.getX();
    }

    public double getSetBackY() {
        return this.setBack.getY();
    }

    public double getSetBackZ() {
        return this.setBack.getZ();
    }

    public void setSetBackY(double y) {
        this.setBack.setY(y);
    }

    public final Location getTeleported() {
        return this.teleported == null ? this.teleported : LocUtil.clone(this.teleported);
    }

    public final void setTeleported(Location loc) {
        this.teleported = LocUtil.clone(loc);
    }

    public boolean hasMorePacketsSetBack() {
        return this.morePacketsSetback != null;
    }

    public final void setMorePacketsSetBack(PlayerLocation loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
    }

    public final void setMorePacketsSetBack(Location loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
    }

    public Location getMorePacketsSetBack() {
        return LocUtil.clone(this.morePacketsSetback);
    }

    public boolean hasMorePacketsVehicleSetBack() {
        return this.morePacketsVehicleSetback != null;
    }

    public final void setMorePacketsVehicleSetBack(PlayerLocation loc) {
        if (this.morePacketsVehicleSetback == null) {
            this.morePacketsVehicleSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsVehicleSetback, loc);
        }
    }

    public final void setMorePacketsVehicleSetBack(Location loc) {
        if (this.morePacketsVehicleSetback == null) {
            this.morePacketsVehicleSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsVehicleSetback, loc);
        }
    }

    public final Location getMorePacketsVehicleSetBack() {
        return LocUtil.clone(this.morePacketsVehicleSetback);
    }

    public final void resetTeleported() {
        this.teleported = null;
    }

    public final void resetSetBack() {
        this.setBack = null;
    }

    public final void setTo(Location to) {
        this.toX = to.getX();
        this.toY = to.getY();
        this.toZ = to.getZ();
        this.toYaw = to.getYaw();
        this.toPitch = to.getPitch();
    }

    public void addVelocity(Player player, MovingConfig cc, double vx, double vy, double vz) {
        int tick = TickTask.getTick();
        this.removeInvalidVelocity(tick - cc.velocityActivationTicks);
        if (this.debug) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, player.getName() + " new velocity: " + vx + ", " + vy + ", " + vz);
        }
        this.verVel.add(new SimpleEntry(tick, vy, cc.velocityActivationCounter));
        if (vx != 0.0 || vz != 0.0) {
            double newVal = Math.sqrt(vx * vx + vz * vz);
            this.horVel.add(new AccountEntry(tick, newVal, cc.velocityActivationCounter, Math.max(20, 1 + (int)Math.round(newVal * 10.0))));
        }
        this.sfDirty = true;
        this.sfNoLowJump = true;
    }

    public void addVerticalVelocity(SimpleEntry entry) {
        this.verVel.add(entry);
    }

    public void addHorizontalVelocity(AccountEntry vel) {
        this.horVel.add(vel);
    }

    public void removeAllVelocity() {
        this.horVel.clear();
        this.verVel.clear();
        this.sfDirty = false;
    }

    public void removeInvalidVelocity(int tick) {
        this.horVel.removeInvalid(tick);
        this.verVel.removeInvalid(tick);
    }

    public void clearActiveHorVel() {
        this.horVel.clearActive();
    }

    public boolean hasActiveHorVel() {
        return this.horVel.hasActive();
    }

    public boolean hasQueuedHorVel() {
        return this.horVel.hasQueued();
    }

    public boolean hasAnyHorVel() {
        return this.horVel.hasAny();
    }

    public boolean hasAnyVerVel() {
        return this.verVel.hasQueued();
    }

    public void velocityTick(int invalidateBeforeTick) {
        this.removeInvalidVelocity(invalidateBeforeTick);
        this.horVel.tick();
        if (!this.sfDirty && (this.horVel.hasActive() || this.horVel.hasQueued())) {
            this.sfDirty = true;
        }
        this.verVelUsed = null;
    }

    public double getHorizontalFreedom() {
        return this.horVel.getFreedom();
    }

    public double useHorizontalVelocity(double amount) {
        double available = this.horVel.use(amount);
        if (available >= amount) {
            this.sfDirty = true;
        }
        return available;
    }

    public void addHorizontalVelocity(StringBuilder builder) {
        if (this.horVel.hasActive()) {
            builder.append("\n horizontal velocity (active):");
            this.horVel.addActive(builder);
        }
        if (this.horVel.hasQueued()) {
            builder.append("\n horizontal velocity (queued):");
            this.horVel.addQueued(builder);
        }
    }

    public SimpleEntry useVerticalVelocity(double amount) {
        SimpleEntry available = this.verVel.use(amount, 0.0625);
        if (available != null) {
            this.sfDirty = true;
            this.verVelUsed = available;
        }
        return available;
    }

    public SimpleEntry getOrUseVerticalVelocity(double amount) {
        if (this.verVelUsed != null && this.verVel.matchesEntry(this.verVelUsed, amount, 0.0625)) {
            return this.verVelUsed;
        }
        return this.useVerticalVelocity(amount);
    }

    public void addVerticalVelocity(StringBuilder builder) {
        if (this.verVel.hasQueued()) {
            builder.append("\n vertical velocity (queued):");
            this.verVel.addQueued(builder);
        }
    }

    public boolean isSetBack(Location loc) {
        if (loc == null || this.setBack == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.setBack.getWorld().getName())) {
            return false;
        }
        return loc.getX() == this.setBack.getX() && loc.getY() == this.setBack.getY() && loc.getZ() == this.setBack.getZ();
    }

    public void onPlayerLeave() {
        this.removeAllVelocity();
        this.deleteTrace();
    }

    public void onWorldUnload(String worldName) {
        if (this.teleported != null && worldName.equalsIgnoreCase(this.teleported.getWorld().getName())) {
            this.resetTeleported();
        }
        if (this.setBack != null && worldName.equalsIgnoreCase(this.setBack.getWorld().getName())) {
            this.clearFlyData();
        }
        if (this.morePacketsSetback != null && worldName.equalsIgnoreCase(this.morePacketsSetback.getWorld().getName()) || this.morePacketsVehicleSetback != null && worldName.equalsIgnoreCase(this.morePacketsVehicleSetback.getWorld().getName())) {
            this.clearMorePacketsData();
            this.clearNoFallData();
        }
    }

    public void adjustWalkSpeed(float walkSpeed, int tick, int speedGrace) {
        if (walkSpeed > this.walkSpeed) {
            this.walkSpeed = walkSpeed;
            this.speedTick = tick;
        } else if (walkSpeed < this.walkSpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.walkSpeed = walkSpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public void adjustFlySpeed(float flySpeed, int tick, int speedGrace) {
        if (flySpeed > this.flySpeed) {
            this.flySpeed = flySpeed;
            this.speedTick = tick;
        } else if (flySpeed < this.flySpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.flySpeed = flySpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public void adjustLiftOffEnvelope(PlayerLocation loc) {
        this.liftOffEnvelope = loc.isInWeb() ? LiftOffEnvelope.NO_JUMP : (loc.isInLiquid() ? LiftOffEnvelope.LIMIT_LIQUID : (loc.isOnGround() ? LiftOffEnvelope.NORMAL : defaultLiftOffEnvelope));
    }

    public boolean hasTrace() {
        return this.trace != null;
    }

    public LocationTrace getTrace(Player player) {
        if (this.trace == null) {
            MovingConfig cc = MovingConfig.getConfig(player);
            this.trace = new LocationTrace(cc.traceSize, cc.traceMergeDist);
        }
        return this.trace;
    }

    public void resetTrace(Player player, Location loc, long time) {
        MovingConfig cc = MovingConfig.getConfig(player);
        this.resetTrace(loc, time, cc.traceSize, cc.traceMergeDist);
    }

    public LocationTrace updateTrace(Player player, Location loc, long time) {
        LocationTrace trace = this.getTrace(player);
        trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ());
        return trace;
    }

    public void resetTrace(Location loc, long time, int size, double mergeDist) {
        if (this.trace == null || this.trace.getMaxSize() != size || this.trace.getMergeDist() != mergeDist) {
            this.trace = new LocationTrace(size, mergeDist);
        } else {
            this.trace.reset();
        }
        this.trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ());
    }

    public void deleteTrace() {
        this.trace = null;
    }

    public boolean isVelocityJumpPhase() {
        return this.sfDirty;
    }

    public boolean resetVelocityJumpPhase() {
        this.sfDirty = this.horVel.hasActive() || this.horVel.hasQueued();
        return this.sfDirty;
    }

    public void setFrictionJumpPhase() {
        this.sfDirty = true;
    }
}

