/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractConfig;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.Direction;
import fr.neatmonster.nocheatplus.checks.blockinteract.Reach;
import fr.neatmonster.nocheatplus.checks.blockinteract.Speed;
import fr.neatmonster.nocheatplus.checks.blockinteract.Visible;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockInteractListener
extends CheckListener {
    private final Direction direction = this.addCheck(new Direction());
    private final Reach reach = this.addCheck(new Reach());
    private final Visible visible = this.addCheck(new Visible());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("canceldead");

    public BlockInteractListener() {
        super(CheckType.BLOCKINTERACT);
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    protected void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        Action action = event.getAction();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockInteractData data = BlockInteractData.getData(player);
        data.setLastBlock(block, action);
        switch (action) {
            case LEFT_CLICK_BLOCK: {
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                ItemStack stack = player.getItemInHand();
                if (stack == null || stack.getType() != Material.ENDER_PEARL || BlockProperties.isPassable(block.getType())) break;
                CombinedConfig ccc = CombinedConfig.getConfig(player);
                if (!ccc.enderPearlCheck || !ccc.enderPearlPreventClickBlock) break;
                event.setUseItemInHand(Event.Result.DENY);
                break;
            }
            default: {
                return;
            }
        }
        if (event.isCancelled()) {
            return;
        }
        BlockInteractConfig cc = BlockInteractConfig.getConfig(player);
        boolean cancelled = false;
        BlockFace face = event.getBlockFace();
        Location loc = player.getLocation(this.useLoc);
        if (!cancelled && this.speed.isEnabled(player) && this.speed.check(player, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.reach.isEnabled(player) && this.reach.check(player, loc, block, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.direction.isEnabled(player) && this.direction.check(player, loc, block, data, cc)) {
            cancelled = true;
        }
        if (!cancelled && this.visible.isEnabled(player) && this.visible.check(player, loc, block, face, action, data, cc)) {
            cancelled = true;
        }
        if (cancelled) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
        }
        this.useLoc.setWorld(null);
    }
}

