/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks;

import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionData;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.actions.types.CancelAction;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.checks.access.IViolationInfo;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationData
implements IViolationInfo,
ActionData {
    public final ActionList actions;
    public final Action<ViolationData, ActionList>[] applicableActions;
    public final double addedVL;
    public final Check check;
    public final Player player;
    public final double vL;
    private Map<ParameterName, String> parameters = null;
    private boolean needsParameters = false;

    public ViolationData(Check check, Player player, double vL, double addedVL, ActionList actions) {
        this.check = check;
        this.player = player;
        this.vL = vL;
        this.addedVL = addedVL;
        this.actions = actions;
        this.applicableActions = actions.getActions(vL);
        boolean needsParameters = false;
        for (int i = 0; i < this.applicableActions.length; ++i) {
            if (!this.applicableActions[i].needsParameters()) continue;
            needsParameters = true;
            break;
        }
        this.needsParameters = needsParameters;
    }

    public Action<ViolationData, ActionList>[] getActions() {
        return this.applicableActions;
    }

    public boolean executeActions() {
        try {
            ViolationHistory.getHistory(this.player).log(this.check.getClass().getName(), this.addedVL);
            long time = System.currentTimeMillis() / 1000L;
            boolean cancel = false;
            for (Action<ViolationData, ActionList> action : this.getActions()) {
                if (!Check.getHistory(this.player).executeAction(this, action, time) || !action.execute(this)) continue;
                cancel = true;
            }
            return cancel;
        }
        catch (Exception e) {
            StaticLog.logSevere(e);
            return true;
        }
    }

    @Override
    public boolean hasCancel() {
        for (Action<ViolationData, ActionList> action : this.applicableActions) {
            if (!(action instanceof CancelAction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getParameter(ParameterName parameterName) {
        if (parameterName == null) {
            return "<???>";
        }
        switch (parameterName) {
            case CHECK: {
                return this.check.getClass().getSimpleName();
            }
            case IP: {
                return this.player.getAddress().toString().substring(1).split(":")[0];
            }
            case PLAYER: 
            case PLAYER_NAME: {
                return this.player.getName();
            }
            case PLAYER_DISPLAY_NAME: {
                return this.player.getDisplayName();
            }
            case UUID: {
                return this.player.getUniqueId().toString();
            }
            case VIOLATIONS: {
                return String.valueOf(Math.round(this.vL));
            }
            case WORLD: {
                return this.player.getWorld().getName();
            }
        }
        if (this.parameters == null) {
            return "[" + parameterName.getText() + "]";
        }
        String value = this.parameters.get((Object)parameterName);
        return value == null ? "[" + parameterName.getText() + "]" : value;
    }

    @Override
    public void setParameter(ParameterName parameterName, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<ParameterName, String>();
        }
        this.parameters.put(parameterName, value);
    }

    public ViolationData chainParameter(ParameterName parameterName, String value) {
        this.setParameter(parameterName, value);
        return this;
    }

    @Override
    public boolean needsParameters() {
        return this.needsParameters;
    }

    @Override
    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public double getAddedVl() {
        return this.addedVL;
    }

    @Override
    public double getTotalVl() {
        return this.vL;
    }

    public String getPermissionSilent() {
        return this.actions.permissionSilent;
    }

    public ActionList getActionList() {
        return this.actions;
    }
}

