/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionUtil {
    public static List<CommandProtectionEntry> protectCommands(Collection<String> commands, String permissionBase, boolean ops) {
        return PermissionUtil.protectCommands(permissionBase, commands, true, ops);
    }

    public static List<CommandProtectionEntry> protectCommands(String permissionBase, Collection<String> ignoredCommands, boolean invertIgnored, boolean ops) {
        return PermissionUtil.protectCommands(permissionBase, ignoredCommands, invertIgnored, ops, ConfigManager.getConfigFile().getString("protection.plugins.hide.messages.unknowncommand"));
    }

    public static List<CommandProtectionEntry> protectCommands(String permissionBase, Collection<String> ignoredCommands, boolean invertIgnored, boolean ops, String permissionMessage) {
        HashSet<String> checked = new HashSet<String>();
        for (String label : ignoredCommands) {
            checked.add(CommandUtil.getCommandLabel(label, false));
        }
        PluginManager pm = Bukkit.getPluginManager();
        Permission rootPerm = pm.getPermission(permissionBase);
        if (rootPerm == null) {
            rootPerm = new Permission(permissionBase);
            pm.addPermission(rootPerm);
        }
        LinkedList<CommandProtectionEntry> changed = new LinkedList<CommandProtectionEntry>();
        for (Command command : CommandUtil.getCommands()) {
            boolean cmdHadPerm;
            String lcLabel = command.getLabel().trim().toLowerCase();
            if (checked != null && (!checked.contains(lcLabel) ? invertIgnored : !invertIgnored)) continue;
            String cmdPermName = command.getPermission();
            if (cmdPermName == null) {
                cmdPermName = permissionBase + "." + lcLabel;
                command.setPermission(cmdPermName);
                cmdHadPerm = false;
            } else {
                cmdHadPerm = true;
            }
            Permission cmdPerm = pm.getPermission(cmdPermName);
            if (cmdPerm == null && !cmdHadPerm) {
                cmdPerm = new Permission(cmdPermName);
                cmdPerm.addParent(rootPerm, true);
                pm.addPermission(cmdPerm);
            }
            if (cmdHadPerm) {
                changed.add(new CommandProtectionEntry(command, lcLabel, cmdPermName, cmdPerm.getDefault(), command.getPermissionMessage()));
            } else {
                changed.add(new CommandProtectionEntry(command, lcLabel, null, null, command.getPermissionMessage()));
            }
            cmdPerm.setDefault(ops ? PermissionDefault.OP : PermissionDefault.FALSE);
            command.setPermissionMessage(permissionMessage);
        }
        return changed;
    }

    public static void addChildPermission(Collection<String> permissions, String childPermissionName, PermissionDefault permissionDefault) {
        PluginManager pm = Bukkit.getPluginManager();
        Permission childPermission = pm.getPermission(childPermissionName);
        if (childPermission == null) {
            childPermission = new Permission(childPermissionName, "auto-generated child permission (NoCheatPlus)", permissionDefault);
            pm.addPermission(childPermission);
        }
        for (String permissionName : permissions) {
            Permission permission = pm.getPermission(permissionName);
            if (permission == null) {
                permission = new Permission(permissionName, "auto-generated permission (NoCheatPlus)", permissionDefault);
                pm.addPermission(permission);
            }
            if (permission.getChildren().containsKey(childPermissionName)) continue;
            childPermission.addParent(permission, true);
        }
    }

    public static class CommandProtectionEntry {
        public final Command command;
        public final String label;
        public final String permission;
        public final PermissionDefault permissionDefault;
        public final String permissionMessage;

        public CommandProtectionEntry(Command command, String label, String permission, PermissionDefault permissionDefault, String permissionMessage) {
            this.command = command;
            this.label = label;
            this.permission = permission;
            this.permissionDefault = permissionDefault;
            this.permissionMessage = permissionMessage;
        }

        public void restore() {
            Permission perm;
            Command registered = CommandUtil.getCommand(this.label);
            if (registered == null || registered != this.command) {
                return;
            }
            if (!this.label.equalsIgnoreCase(this.command.getLabel().trim().toLowerCase())) {
                this.command.setLabel(this.label);
            }
            this.command.setPermission(this.permission);
            if (this.permission != null && this.permissionDefault != null && (perm = Bukkit.getPluginManager().getPermission(this.permission)) != null) {
                perm.setDefault(this.permissionDefault);
            }
            this.command.setPermissionMessage(this.permissionMessage);
        }
    }
}

