/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.config;

import fr.neatmonster.nocheatplus.config.ConfPaths;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.GlobalConfig;
import fr.neatmonster.nocheatplus.config.Moved;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.CharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtils {
    private static final Set<String> deprecatedFields = new LinkedHashSet<String>();
    private static final SimpleCharPrefixTree deprecatedPrefixes = new SimpleCharPrefixTree();
    private static final Set<String> globalOnlyFields = new HashSet<String>();
    private static final SimpleCharPrefixTree globalOnlyPrefixes = new SimpleCharPrefixTree();
    private static final Map<String, String> movedPaths = new LinkedHashMap<String, String>();

    private static void initPaths() {
        deprecatedFields.clear();
        deprecatedPrefixes.clear();
        globalOnlyFields.clear();
        globalOnlyPrefixes.clear();
        movedPaths.clear();
        for (Field field : ConfPaths.class.getDeclaredFields()) {
            if (field.getType() != String.class) continue;
            String fieldName = field.getName();
            PathUtils.checkAddPrefixes(field, fieldName, GlobalConfig.class, globalOnlyFields, globalOnlyPrefixes);
            PathUtils.checkAddPrefixes(field, fieldName, Deprecated.class, deprecatedFields, deprecatedPrefixes);
            if (!field.isAnnotationPresent(Moved.class)) continue;
            PathUtils.addMoved(field, field.getAnnotation(Moved.class));
        }
    }

    private static void checkAddPrefixes(Field field, String fieldName, Class<? extends Annotation> annotation, Set<String> fieldNames, SimpleCharPrefixTree pathPrefixes) {
        if (field.isAnnotationPresent(annotation)) {
            fieldNames.add(fieldName);
            PathUtils.addPrefixesField(field, pathPrefixes);
        } else {
            for (String refName : fieldNames) {
                if (!fieldName.startsWith(refName)) continue;
                PathUtils.addPrefixesField(field, pathPrefixes);
            }
        }
    }

    private static void addPrefixesField(Field field, SimpleCharPrefixTree pathPrefixes) {
        try {
            String path = field.get(null).toString();
            if (path != null) {
                pathPrefixes.feed(path);
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void addMoved(Field field, Moved rel) {
        try {
            String path = field.get(null).toString();
            movedPaths.put(path, rel.newPath());
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected static void warnPaths(ConfigFile config, CharPrefixTree<?, ?> paths, String msgPrefix, Set<String> warnedPaths) {
        Logger logger = Bukkit.getLogger();
        for (String path : config.getKeys(true)) {
            if (!paths.hasPrefix(path)) continue;
            logger.warning("[NoCheatPlus] Config path '" + path + "'" + msgPrefix);
            if (warnedPaths == null) continue;
            warnedPaths.add(path);
        }
    }

    public static void processPaths(File file, String configName, boolean isWorldConfig) {
        ConfigFile config = new ConfigFile();
        try {
            config.load(file);
            LinkedHashSet<String> removePaths = new LinkedHashSet<String>();
            LinkedHashMap<String, Object> addPaths = new LinkedHashMap<String, Object>();
            if (isWorldConfig) {
                PathUtils.processGlobalOnlyPaths(config, configName, null);
            }
            PathUtils.processDeprecatedPaths(config, configName, removePaths);
            PathUtils.processMovedPaths(config, configName, removePaths, addPaths);
            boolean changed = false;
            if (!removePaths.isEmpty()) {
                config = PathUtils.removePaths(config, removePaths);
                changed = true;
            }
            if (!addPaths.isEmpty()) {
                PathUtils.setPaths(config, addPaths);
                changed = true;
            }
            if (changed) {
                try {
                    config.save(file);
                }
                catch (Throwable t) {
                    LogUtil.logSevere("[NoCheatPlus] Failed to save configuration (" + configName + ") with changes: " + t.getClass().getSimpleName());
                    LogUtil.logSevere(t);
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (InvalidConfigurationException e) {
            // empty catch block
        }
    }

    public static void setPaths(ConfigFile config, Map<String, Object> setPaths) {
        for (Map.Entry<String, Object> entry : setPaths.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
    }

    public static ConfigFile removePaths(ConfigFile config, Collection<String> removePaths) {
        SimpleCharPrefixTree prefixes = new SimpleCharPrefixTree();
        for (String path : removePaths) {
            prefixes.feed(path);
        }
        ConfigFile newConfig = new ConfigFile();
        for (Map.Entry entry : config.getValues(true).entrySet()) {
            String path = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection || prefixes.hasPrefix(path)) continue;
            newConfig.set(path, value);
        }
        return newConfig;
    }

    protected static void processMovedPaths(ConfigFile config, String configName, Set<String> removePaths, Map<String, Object> addPaths) {
        Logger logger = Bukkit.getLogger();
        for (Map.Entry<String, String> entry : movedPaths.entrySet()) {
            String to;
            String path = entry.getKey();
            if (!config.contains(path)) continue;
            String newPath = entry.getValue();
            if (newPath == null | newPath.isEmpty()) {
                to = ".";
            } else {
                to = " to '" + newPath + "'.";
                Object value = config.get(path);
                config.set(newPath, value);
                addPaths.put(newPath, value);
                removePaths.add(path);
            }
            logger.warning("[NoCheatPlus] Config path '" + path + "' (" + configName + ") has been moved" + to);
        }
    }

    protected static void processDeprecatedPaths(ConfigFile config, String configName, Set<String> removePaths) {
        PathUtils.warnPaths(config, deprecatedPrefixes, " (" + configName + ") is not in use anymore.", removePaths);
    }

    protected static void processGlobalOnlyPaths(ConfigFile config, String configName, Set<String> removePaths) {
        PathUtils.warnPaths(config, globalOnlyPrefixes, " (" + configName + ") should only be set in the global configuration.", removePaths);
    }

    public static MemoryConfiguration getWorldsDefaultConfig(ConfigFile defaultConfig) {
        char sep = defaultConfig.options().pathSeparator();
        ConfigFile config = new ConfigFile();
        config.options().pathSeparator(sep);
        Map defaults = defaultConfig.getValues(false);
        for (Map.Entry entry : defaults.entrySet()) {
            String part = (String)entry.getKey();
            if (!part.isEmpty() && !PathUtils.mayBeInWorldConfig(part)) continue;
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                PathUtils.addWorldConfigSection((MemoryConfiguration)config, (ConfigurationSection)value, part, sep);
                continue;
            }
            config.set(part, value);
        }
        return config;
    }

    protected static void addWorldConfigSection(MemoryConfiguration config, ConfigurationSection section, String path, char sep) {
        Map values = section.getValues(false);
        for (Map.Entry entry : values.entrySet()) {
            String fullPath = path + sep + (String)entry.getKey();
            if (!PathUtils.mayBeInWorldConfig(fullPath)) continue;
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                PathUtils.addWorldConfigSection(config, (ConfigurationSection)value, fullPath, sep);
                continue;
            }
            config.set(fullPath, value);
        }
    }

    public static boolean mayBeInWorldConfig(String path) {
        if (globalOnlyPrefixes.hasPrefix(path)) {
            return false;
        }
        return PathUtils.mayBeInConfig(path);
    }

    public static boolean mayBeInConfig(String path) {
        if (deprecatedPrefixes.hasPrefix(path)) {
            return false;
        }
        return !movedPaths.containsKey(path);
    }

    static {
        PathUtils.initPaths();
    }
}

