/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.exemption;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnexemptCommand
extends BaseCommand {
    public UnexemptCommand(JavaPlugin plugin) {
        super(plugin, "unexempt", "nocheatplus.admin.unexempt");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CheckType checkType;
        if (args.length < 2 || args.length > 3) {
            return false;
        }
        String playerName = args[1];
        if (args.length == 3) {
            try {
                checkType = CheckType.valueOf(args[2].toUpperCase().replace('-', '_').replace('.', '_'));
            }
            catch (Exception e) {
                sender.sendMessage(TAG + "Could not interpret: " + args[2]);
                sender.sendMessage(TAG + "Check type should be one of: " + StringUtil.join(Arrays.asList(CheckType.values()), (String)" | "));
                return true;
            }
        } else {
            checkType = CheckType.ALL;
        }
        if (playerName.equals("*")) {
            NCPExemptionManager.clear();
            sender.sendMessage(TAG + "Nobody will be exempted from: " + (Object)((Object)checkType));
            return true;
        }
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
        }
        NCPExemptionManager.unexempt(playerName, checkType);
        sender.sendMessage(TAG + "Player " + playerName + " will not be exempted from: " + (Object)((Object)checkType));
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 3) {
            return CommandUtil.getCheckTypeTabMatches(args[2]);
        }
        return null;
    }
}

