/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovePlayerCommand
extends BaseCommand {
    public RemovePlayerCommand(JavaPlugin plugin) {
        super(plugin, "removeplayer", "nocheatplus.admin.removeplayer", new String[]{"remove"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean dataRemoved;
        CheckType checkType;
        if (args.length < 2 || args.length > 3) {
            return false;
        }
        String playerName = args[1];
        if (args.length == 3) {
            try {
                checkType = CheckType.valueOf(args[2].toUpperCase().replace('-', '_').replace('.', '_'));
            }
            catch (Exception e) {
                sender.sendMessage(TAG + "Could not interpret: " + args[2]);
                sender.sendMessage(TAG + "Check type should be one of: " + StringUtil.join(Arrays.asList(CheckType.values()), (String)" | "));
                return true;
            }
        } else {
            checkType = CheckType.ALL;
        }
        if (playerName.equals("*")) {
            DataManager.clearData(checkType);
            sender.sendMessage(TAG + "Removed all data and history: " + (Object)((Object)checkType));
            return true;
        }
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
        }
        ViolationHistory hist = ViolationHistory.getHistory(playerName, false);
        boolean histRemoved = false;
        if (hist != null) {
            histRemoved = hist.remove(checkType);
            if (checkType == CheckType.ALL) {
                histRemoved = true;
                ViolationHistory.removeHistory(playerName);
            }
        }
        if (DataManager.removeExecutionHistory(checkType, playerName)) {
            histRemoved = true;
        }
        if ((dataRemoved = DataManager.removeData(playerName, checkType)) || histRemoved) {
            String which = dataRemoved && histRemoved ? "data and history" : (dataRemoved ? "data" : "history");
            sender.sendMessage(TAG + "Removed " + which + " (" + (Object)((Object)checkType) + "): " + playerName);
        } else {
            sender.sendMessage(TAG + "Nothing found (" + (Object)((Object)checkType) + ", exact spelling): " + playerName);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 3) {
            return CommandUtil.getCheckTypeTabMatches(args[2]);
        }
        return null;
    }
}

