/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.command.AbstractCommand;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempKickCommand
extends BaseCommand {
    public TempKickCommand(JavaPlugin plugin) {
        super(plugin, "tempkick", "nocheatplus.admin.tempkick", new String[]{"tkick", "tempban", "tban"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 3) {
            return false;
        }
        long base = 60000L;
        String name = args[1];
        long duration = -1L;
        try {
            duration = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (duration <= 0L) {
            return false;
        }
        long finalDuration = duration * base;
        String reason = args.length > 3 ? AbstractCommand.join(args, 3) : "";
        this.tempKick(sender, name, finalDuration, reason);
        return true;
    }

    protected void tempKick(CommandSender sender, String name, long duration, String reason) {
        Player player = DataManager.getPlayer(name);
        NCPAPIProvider.getNoCheatPlusAPI().denyLogin(name, duration);
        if (player == null) {
            return;
        }
        player.kickPlayer(reason);
        LogUtil.logInfo("[NoCheatPlus] (" + sender.getName() + ") Kicked " + player.getName() + " for " + duration / 60000L + " minutes: " + reason);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

