/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.PassableRayTracing;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Passable
extends Check {
    private final PassableRayTracing rayTracing = new PassableRayTracing();

    public Passable() {
        super(CheckType.MOVING_PASSABLE);
        this.rayTracing.setMaxSteps(60);
    }

    public Location check(Player player, Location loc, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        boolean toPassable = to.isPassable();
        if (!(!toPassable || !cc.passableRayTracingCheck || cc.passableRayTracingVclipOnly && !(from.getY() > to.getY()) || cc.passableRayTracingBlockChangeOnly && from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ())) {
            this.rayTracing.set(from, to);
            this.rayTracing.loop();
            if (this.rayTracing.collides() || this.rayTracing.getStepsDone() >= this.rayTracing.getMaxSteps()) {
                toPassable = false;
            }
            this.rayTracing.cleanup();
        }
        if (toPassable) {
            data.passableVL *= 0.99;
            return null;
        }
        int lbX = loc.getBlockX();
        int lbY = loc.getBlockY();
        int lbZ = loc.getBlockZ();
        if (from.isPassable()) {
            loc = null;
        } else if (!BlockProperties.isPassable(from.getBlockCache(), loc.getX(), loc.getY(), loc.getZ(), from.getTypeId(lbX, lbY, lbZ)) && from.isSameBlock(lbX, lbY, lbZ)) {
            if (to.isBlockAbove(from) && BlockProperties.isPassable(from.getBlockCache(), from.getX(), from.getY() + player.getEyeHeight(), from.getZ(), from.getTypeId(from.getBlockX(), Location.locToBlock((double)(from.getY() + player.getEyeHeight())), from.getBlockZ()))) {
                return null;
            }
            if (!from.isSameBlock(to)) {
                loc = null;
            } else {
                return null;
            }
        }
        if (data.hasSetBack()) {
            Location ref = data.getSetBack(to);
            if (BlockProperties.isPassable(from.getBlockCache(), ref)) {
                loc = ref;
            }
        }
        data.passableVL += 1.0;
        ViolationData vd = new ViolationData(this, player, data.passableVL, 1.0, cc.passableActions);
        if (cc.debug || vd.needsParameters()) {
            vd.setParameter(ParameterName.BLOCK_ID, "" + to.getTypeId());
        }
        if (this.executeActions(vd)) {
            Location newTo = loc != null ? loc : from.getLocation();
            newTo.setYaw(to.getYaw());
            newTo.setPitch(to.getPitch());
            return newTo;
        }
        return null;
    }

    @Override
    protected Map<ParameterName, String> getParameterMap(ViolationData violationData) {
        return super.getParameterMap(violationData);
    }
}

