/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.BedLeave;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.moving.CreativeFly;
import fr.neatmonster.nocheatplus.checks.moving.MorePackets;
import fr.neatmonster.nocheatplus.checks.moving.MorePacketsVehicle;
import fr.neatmonster.nocheatplus.checks.moving.MoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.NoFall;
import fr.neatmonster.nocheatplus.checks.moving.Passable;
import fr.neatmonster.nocheatplus.checks.moving.SurvivalFly;
import fr.neatmonster.nocheatplus.checks.moving.Velocity;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.components.IData;
import fr.neatmonster.nocheatplus.components.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.INeedConfig;
import fr.neatmonster.nocheatplus.components.INotifyReload;
import fr.neatmonster.nocheatplus.components.IRemoveData;
import fr.neatmonster.nocheatplus.components.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.TickListener;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.logging.DebugUtil;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.BlockCache;
import fr.neatmonster.nocheatplus.utilities.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TeleportUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MovingListener
extends CheckListener
implements TickListener,
IRemoveData,
IHaveCheckType,
INotifyReload,
INeedConfig,
JoinLeaveListener {
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("NoCheatPlus");
    public final NoFall noFall = this.addCheck(new NoFall());
    private final CreativeFly creativeFly = this.addCheck(new CreativeFly());
    private final MorePackets morePackets = this.addCheck(new MorePackets());
    private final MorePacketsVehicle morePacketsVehicle = this.addCheck(new MorePacketsVehicle());
    private final SurvivalFly survivalFly = this.addCheck(new SurvivalFly());
    private final Passable passable = this.addCheck(new Passable());
    private final BedLeave bedLeave = this.addCheck(new BedLeave());
    private final List<MoveInfo> parkedInfo = new ArrayList<MoveInfo>(10);
    private final Map<String, PlayerMoveEvent> processingEvents = new HashMap<String, PlayerMoveEvent>();
    private final Set<String> hoverTicks = new LinkedHashSet<String>(30);
    private int hoverTicksStep = 5;
    private final Set<EntityType> normalVehicles = new HashSet<EntityType>();

    public static final boolean shouldCheckSurvivalFly(Player player, MovingData data, MovingConfig cc) {
        if (player.hasPermission("nocheatplus.checks.moving.creativefly")) {
            return false;
        }
        if (!cc.survivalFlyCheck || NCPExemptionManager.isExempted(player, CheckType.MOVING_SURVIVALFLY) || player.hasPermission("nocheatplus.checks.moving.survivalfly")) {
            return false;
        }
        return !(!cc.ignoreCreative && player.getGameMode() == GameMode.CREATIVE || !cc.ignoreAllowFlight && player.getAllowFlight());
    }

    public static void handleIllegalMove(PlayerMoveEvent event, Player player, MovingData data) {
        boolean restored = false;
        PlayerLocation pLoc = new PlayerLocation(NCPAPIProvider.getNoCheatPlusAPI().getMCAccess(), null);
        Location loc = player.getLocation();
        if (!restored && data.hasSetBack()) {
            Location setBack = data.getSetBack(loc);
            pLoc.set(setBack, player);
            if (!pLoc.isIllegal()) {
                event.setFrom(setBack);
                event.setTo(setBack);
                restored = true;
            } else {
                data.resetSetBack();
            }
        }
        if (!restored) {
            pLoc.set(loc, player);
            if (!pLoc.isIllegal()) {
                event.setFrom(loc);
                event.setTo(loc);
                restored = true;
            }
        }
        pLoc.cleanup();
        if (!restored && MovingConfig.getConfig((Player)player).tempKickIllegal) {
            NCPAPIProvider.getNoCheatPlusAPI().denyLogin(player.getName(), 86400000L);
            LogUtil.logSevere("[NCP] could not restore location for " + player.getName() + " deny login for 24 hours");
        }
        CheckUtils.kickIllegalMove(player);
    }

    public MovingListener() {
        super(CheckType.MOVING);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.isInsideVehicle()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        int blockY = block.getY();
        Material mat = block.getType();
        MovingData data = MovingData.getData(player);
        if (!this.creativeFly.isEnabled(player) && !this.survivalFly.isEnabled(player)) {
            return;
        }
        if (!data.hasSetBack() || (double)blockY + 1.0 < data.getSetBackY()) {
            return;
        }
        Location loc = player.getLocation();
        if (Math.abs(loc.getX() - 0.5 - (double)block.getX()) <= 1.0 && Math.abs(loc.getZ() - 0.5 - (double)block.getZ()) <= 1.0 && loc.getY() - (double)blockY > 0.0 && loc.getY() - (double)blockY < 2.0 && (this.canJumpOffTop(mat.getId()) || BlockProperties.isLiquid(mat.getId()))) {
            data.setSetBackY((double)blockY + 1.0);
            data.sfJumpPhase = 0;
        }
    }

    private final boolean canJumpOffTop(int id) {
        return BlockProperties.isGround(id) || BlockProperties.isSolid(id);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        CombinedData.getData((Player)event.getPlayer()).wasInBed = true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        if (this.bedLeave.isEnabled(player) && this.bedLeave.checkBed(player)) {
            Location loc = player.getLocation();
            MovingData data = MovingData.getData(player);
            MovingConfig cc = MovingConfig.getConfig(player);
            Location target = null;
            boolean sfCheck = MovingListener.shouldCheckSurvivalFly(player, data, cc);
            if (sfCheck) {
                target = data.getSetBack(loc);
            }
            if (target == null) {
                target = loc;
            }
            if (target != null) {
                if (sfCheck && cc.sfFallDamage && this.noFall.isEnabled(player)) {
                    double y = loc.getY();
                    if (data.hasSetBack()) {
                        y = Math.min(y, data.getSetBackY());
                    }
                    this.noFall.checkDamage(player, data, y);
                }
                data.setTeleported(target);
                player.teleport(target, PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
        } else {
            CombinedData.getData((Player)player).wasInBed = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        data.clearFlyData();
        data.clearMorePacketsData();
        data.setSetBack(player.getLocation());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE || event.getNewGameMode() == GameMode.CREATIVE) {
            MovingData data = MovingData.getData(event.getPlayer());
            data.clearFlyData();
            data.clearMorePacketsData();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        boolean checkCf;
        boolean checkSf;
        double jumpAmplifier;
        Player player = event.getPlayer();
        String playerName = player.getName();
        this.processingEvents.put(playerName, event);
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            Entity vehicle = CheckUtils.getLastNonPlayerVehicle((Entity)player);
            data.wasInVehicle = true;
            data.sfHoverTicks = -1;
            data.removeAllVelocity();
            data.sfLowJump = false;
            if (vehicle != null && !this.normalVehicles.contains(vehicle.getType())) {
                this.onVehicleMove(vehicle, event.getFrom(), event.getFrom(), true);
            }
            return;
        }
        if (player.isDead()) {
            data.sfHoverTicks = -1;
            return;
        }
        if (player.isSleeping()) {
            data.sfHoverTicks = -1;
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (!from.getWorld().equals(to.getWorld())) {
            return;
        }
        MoveInfo moveInfo = this.parkedInfo.isEmpty() ? new MoveInfo(this.mcAccess) : this.parkedInfo.remove(this.parkedInfo.size() - 1);
        MovingConfig cc = MovingConfig.getConfig(player);
        moveInfo.set(player, from, to, cc.yOnGround);
        data.noFallAssumeGround = false;
        data.resetTeleported();
        if (cc.debug) {
            DebugUtil.outputMoveDebug(player, moveInfo.from, moveInfo.to, Math.max(cc.noFallyOnGround, cc.yOnGround), this.mcAccess);
        }
        if (moveInfo.from.isIllegal() || moveInfo.to.isIllegal()) {
            MovingListener.handleIllegalMove(event, player, data);
            moveInfo.cleanup();
            this.parkedInfo.add(moveInfo);
            return;
        }
        long time = System.currentTimeMillis();
        if (player.isSprinting() && player.getFoodLevel() > 5) {
            data.timeSprinting = time;
        } else if (time < data.timeSprinting) {
            data.timeSprinting = 0L;
        }
        PlayerLocation pFrom = moveInfo.from;
        PlayerLocation pTo = moveInfo.to;
        if (data.wasInVehicle) {
            if (cc.debug) {
                LogUtil.logWarning("[NoCheatPlus] VehicleExitEvent missing for: " + player.getName());
            }
            this.onPlayerVehicleLeave(player);
            data.noFallSkipAirCheck = true;
            data.sfLowJump = false;
            data.clearNoFallData();
        }
        if ((jumpAmplifier = this.survivalFly.getJumpAmplifier(player)) > data.jumpAmplifier) {
            data.jumpAmplifier = jumpAmplifier;
        }
        data.removeInvalidVelocity(TickTask.getTick() - cc.velocityActivationTicks);
        data.velocityTick();
        if (data.verticalVelocity <= 0.09) {
            ++data.verticalVelocityUsed;
            --data.verticalVelocityCounter;
        } else if ((double)data.verticalVelocityCounter > 0.0) {
            ++data.verticalVelocityUsed;
            data.verticalFreedom += data.verticalVelocity;
            data.verticalVelocity = Math.max(0.0, data.verticalVelocity - 0.09);
        } else if (data.verticalFreedom > 0.001) {
            if (data.verticalVelocityUsed == 1 && data.verticalVelocity > 1.0) {
                data.verticalVelocityUsed = 0;
                data.verticalVelocity = 0.0;
                data.verticalFreedom = 0.0;
            } else {
                ++data.verticalVelocityUsed;
                data.verticalFreedom *= 0.93;
            }
        }
        Location loc = cc.noFallCheck || cc.passableCheck ? player.getLocation() : null;
        Location newTo = null;
        boolean mightSkipNoFall = false;
        if (newTo == null && cc.passableCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_PASSABLE) && !player.hasPermission("nocheatplus.checks.moving.passable") && (newTo = this.passable.check(player, loc, pFrom, pTo, data, cc)) != null) {
            mightSkipNoFall = true;
        }
        if (player.hasPermission("nocheatplus.checks.moving.creativefly")) {
            checkSf = false;
            checkCf = false;
        } else if (!(!cc.ignoreCreative && player.getGameMode() == GameMode.CREATIVE || !cc.ignoreAllowFlight && player.getAllowFlight() || !cc.survivalFlyCheck || NCPExemptionManager.isExempted(player, CheckType.MOVING_SURVIVALFLY) || player.hasPermission("nocheatplus.checks.moving.survivalfly"))) {
            checkCf = false;
            checkSf = true;
        } else if (cc.creativeFlyCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_CREATIVEFLY)) {
            checkCf = true;
            checkSf = false;
        } else {
            checkSf = false;
            checkCf = false;
        }
        if (checkSf) {
            boolean checkNf;
            double maxYNoFall = Math.max(cc.noFallyOnGround, cc.yOnGround);
            pFrom.collectBlockFlags(maxYNoFall);
            if (pFrom.isSamePos(pTo)) {
                pTo.prepare(pFrom);
            } else {
                pTo.collectBlockFlags(maxYNoFall);
            }
            if (newTo == null) {
                newTo = this.survivalFly.check(player, pFrom, pTo, data, cc, time);
            }
            boolean bl = checkNf = cc.noFallCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_NOFALL) && !player.hasPermission("nocheatplus.checks.moving.nofall");
            if (newTo == null) {
                if (cc.sfHoverCheck && !data.toWasReset && !pTo.isOnGround()) {
                    this.hoverTicks.add(playerName);
                    data.sfHoverTicks = 0;
                } else {
                    data.sfHoverTicks = -1;
                }
                if (checkNf) {
                    this.noFall.check(player, loc, pFrom, pTo, data, cc);
                }
            } else if (checkNf && cc.sfFallDamage) {
                if (mightSkipNoFall && !pFrom.isOnGround() && !pFrom.isResetCond()) {
                    mightSkipNoFall = false;
                }
                if (!mightSkipNoFall) {
                    this.noFall.checkDamage(player, data, Math.min(Math.min(from.getY(), to.getY()), loc.getY()));
                }
            }
        } else if (checkCf) {
            newTo = this.creativeFly.check(player, pFrom, pTo, data, cc, time);
            data.sfHoverTicks = -1;
            data.sfLowJump = false;
        } else {
            data.clearFlyData();
        }
        if (newTo == null && cc.morePacketsCheck && !NCPExemptionManager.isExempted(player, CheckType.MOVING_MOREPACKETS) && !player.hasPermission("nocheatplus.checks.moving.morepackets")) {
            newTo = this.morePackets.check(player, pFrom, pTo, data, cc);
        } else {
            data.clearMorePacketsData();
        }
        if (newTo != null) {
            data.clearAccounting();
            data.sfJumpPhase = 0;
            data.sfLastYDist = Double.MAX_VALUE;
            data.toWasReset = false;
            data.fromWasReset = false;
            event.setTo(newTo);
            data.setTeleported(newTo);
            if (cc.debug) {
                System.out.println(player.getName() + " set back to: " + newTo.getWorld() + StringUtil.fdec3.format(newTo.getX()) + ", " + StringUtil.fdec3.format(newTo.getY()) + ", " + StringUtil.fdec3.format(newTo.getZ()));
            }
        }
        data.fromX = from.getX();
        data.fromY = from.getY();
        data.fromZ = from.getZ();
        data.toX = to.getX();
        data.toY = to.getY();
        data.toZ = to.getZ();
        moveInfo.cleanup();
        this.parkedInfo.add(moveInfo);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public final void onPlayerMoveMonitor(PlayerMoveEvent event) {
        long now = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (this.processingEvents.remove(player.getName()) == null) {
            return;
        }
        if (player.isDead() || player.isSleeping()) {
            return;
        }
        CombinedData data = CombinedData.getData(player);
        data.lastMoveTime = now;
        Location from = event.getFrom();
        String fromWorldName = from.getWorld().getName();
        if (!event.isCancelled()) {
            Location to = event.getTo();
            String toWorldName = to.getWorld().getName();
            Combined.feedYawRate(player, to.getYaw(), now, toWorldName, data);
            if (player.isInsideVehicle() || !fromWorldName.equals(toWorldName)) {
                MovingData.getData(player).resetPositions(to);
            } else {
                MovingData.getData(player).setTo(to);
            }
        } else {
            Combined.feedYawRate(player, from.getYaw(), now, fromWorldName, data);
            MovingData.getData(player).resetPositions(from);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        MovingData data = MovingData.getData(event.getPlayer());
        data.clearFlyData();
        data.clearMorePacketsData();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        data.clearFlyData();
        data.clearMorePacketsData();
        data.resetSetBack();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        MovingData data = MovingData.getData(player);
        data.clearFlyData();
        data.clearMorePacketsData();
        data.setSetBack(player.getLocation());
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Location ref;
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        Location teleported = data.getTeleported();
        Location to = event.getTo();
        if (teleported != null && teleported.equals((Object)to)) {
            if (event.isCancelled()) {
                event.setCancelled(false);
                event.setTo(teleported);
                event.setFrom(teleported);
                ref = teleported;
            } else {
                ref = to;
            }
            data.onSetBack(teleported);
        } else {
            MovingConfig cc = MovingConfig.getConfig(player);
            if (to != null && !event.isCancelled()) {
                boolean smallRange = false;
                boolean cancel = false;
                double margin = 0.67;
                Location from = event.getFrom();
                PlayerTeleportEvent.TeleportCause cause = event.getCause();
                if (cause == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
                    if (from != null && from.getWorld().equals(to.getWorld())) {
                        if (TrigUtil.distance(from, to) < 0.67) {
                            smallRange = true;
                        } else if (data.toX != Double.MAX_VALUE && data.hasSetBack()) {
                            Location setBack = data.getSetBack(to);
                            if (TrigUtil.distance(to.getX(), to.getY(), to.getZ(), setBack.getX(), setBack.getY(), setBack.getZ()) < 0.67) {
                                smallRange = true;
                            }
                        }
                    }
                } else if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && CombinedConfig.getConfig((Player)player).enderPearlCheck && !BlockProperties.isPassable(to)) {
                    cancel = true;
                }
                if (cancel) {
                    if (data.hasSetBack() && !data.hasSetBackWorldChanged(to)) {
                        ref = data.getSetBack(to);
                        event.setTo(ref);
                    } else {
                        ref = from;
                        event.setCancelled(true);
                    }
                } else if (smallRange) {
                    ref = to;
                } else {
                    ref = to;
                    double fallDistance = data.noFallFallDistance;
                    data.clearMorePacketsData();
                    data.clearFlyData();
                    data.resetPositions(to);
                    data.setSetBack(to);
                    if (fallDistance > 1.0 && fallDistance - (double)player.getFallDistance() > 0.0 && !cc.noFallTpReset) {
                        player.setFallDistance((float)fallDistance);
                    }
                    if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                        data.noFallSkipAirCheck = true;
                    }
                    data.sfHoverTicks = -1;
                }
                if (cc.debug && BuildParameters.debugLevel > 0) {
                    System.out.println(player.getName() + " TP" + (smallRange ? " (small-range)" : "") + (cancel ? " (cancelled)" : "") + ": " + to);
                }
            } else {
                data.resetTeleported();
                if (cc.debug && BuildParameters.debugLevel > 0) {
                    System.out.println(player.getName() + " TP (cancelled): " + to);
                }
                return;
            }
        }
        Combined.resetYawRate(player, ref.getYaw(), System.currentTimeMillis(), true);
        data.resetTeleported();
        this.processingEvents.remove(player.getName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        MovingData data = MovingData.getData(player);
        if (player.isInsideVehicle()) {
            data.removeAllVelocity();
            return;
        }
        MovingConfig cc = MovingConfig.getConfig(player);
        int tick = TickTask.getTick();
        data.removeInvalidVelocity(tick - cc.velocityActivationTicks);
        Vector velocity = event.getVelocity();
        if (cc.debug) {
            System.out.println(event.getPlayer().getName() + " new velocity: " + velocity);
        }
        double newVal = velocity.getY();
        boolean used = false;
        if (newVal >= 0.0) {
            used = true;
            if (data.verticalFreedom <= 0.001 && data.verticalVelocityCounter >= 0) {
                data.verticalVelocity = 0.0;
            }
            data.verticalVelocity += newVal;
            data.verticalFreedom += data.verticalVelocity;
            data.verticalVelocityCounter = Math.min(100, Math.max(data.verticalVelocityCounter, cc.velocityGraceTicks) + 1 + (int)Math.round(newVal * 10.0));
            data.verticalVelocityUsed = 0;
        }
        if ((newVal = Math.sqrt(velocity.getX() * velocity.getX() + velocity.getZ() * velocity.getZ())) > 0.0) {
            used = true;
            Velocity vel = new Velocity(tick, newVal, cc.velocityActivationCounter, Math.max(20, 1 + (int)Math.round(newVal * 10.0)));
            data.addHorizontalVelocity(vel);
        }
        if (used) {
            data.sfDirty = true;
            data.sfNoLowJump = true;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        EntityType entityType = vehicle.getType();
        if (!this.normalVehicles.contains(entityType)) {
            this.normalVehicles.add(entityType);
            if (MovingConfig.getConfig((String)vehicle.getWorld().getName()).debug) {
                System.out.println("[NoCheatPlus] VehicleMoveEvent fired for: " + entityType);
            }
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        this.onVehicleMove((Entity)vehicle, event.getFrom(), event.getTo(), false);
    }

    public void onVehicleMove(Entity vehicle, Location from, Location to, boolean fake) {
        Player player = CheckUtils.getFirstPlayerPassenger(vehicle);
        if (player == null) {
            return;
        }
        if (!from.getWorld().equals(to.getWorld())) {
            return;
        }
        Location newTo = null;
        final MovingData data = MovingData.getData(player);
        data.sfNoLowJump = true;
        MovingConfig cc = MovingConfig.getConfig(player);
        if (cc.noFallVehicleReset) {
            data.noFallSkipAirCheck = true;
            data.sfLowJump = false;
            data.clearNoFallData();
        }
        if (this.morePacketsVehicle.isEnabled(player)) {
            newTo = this.morePacketsVehicle.check(player, from, to, data, cc);
        } else {
            data.clearMorePacketsData();
        }
        if (newTo != null && data.morePacketsVehicleTaskId == -1) {
            data.morePacketsVehicleTaskId = Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){
                private Entity vehicle;
                private Player player;
                private Location location;

                public void run() {
                    data.morePacketsVehicleTaskId = -1;
                    try {
                        MovingData.getData(this.player).setTeleported(this.location);
                        TeleportUtil.teleport(this.vehicle, this.player, this.location, MovingConfig.getConfig((Player)this.player).debug);
                    }
                    catch (Throwable t) {
                        LogUtil.logSevere(t);
                    }
                }

                public Runnable set(Entity vehicle, Player player, Location location) {
                    this.vehicle = vehicle;
                    this.player = player;
                    this.location = location;
                    return this;
                }
            }.set(vehicle, player, newTo), 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onEntityDamage(EntityDamageEvent event) {
        double maxD;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MovingData data = MovingData.getData(player);
        MovingConfig cc = MovingConfig.getConfig(player);
        if (event.isCancelled() || !MovingListener.shouldCheckSurvivalFly(player, data, cc) || !this.noFall.isEnabled(player)) {
            data.clearNoFallData();
            return;
        }
        Location loc = player.getLocation();
        boolean allowReset = true;
        if (!data.noFallSkipAirCheck) {
            MoveInfo moveInfo = this.parkedInfo.isEmpty() ? new MoveInfo(this.mcAccess) : this.parkedInfo.remove(this.parkedInfo.size() - 1);
            moveInfo.set(player, loc, null, cc.noFallyOnGround);
            PlayerLocation pLoc = moveInfo.from;
            moveInfo.from.collectBlockFlags(cc.noFallyOnGround);
            data.noFallFallDistance = (float)((double)data.noFallFallDistance + 1.0);
            if (!(pLoc.isOnGround(1.0, 0.3, 0.1) || pLoc.isResetCond() || pLoc.isAboveLadder() || pLoc.isAboveStairs())) {
                data.noFallVL += 1.0;
                if (this.noFall.executeActions(player, data.noFallVL, 1.0, cc.noFallActions, true) && data.hasSetBack()) {
                    allowReset = false;
                }
            } else {
                data.vDistAcc.clear();
            }
            moveInfo.cleanup();
            this.parkedInfo.add(moveInfo);
        }
        float fallDistance = player.getFallDistance();
        double damage = BridgeHealth.getDamage(event);
        float yDiff = (float)(data.noFallMaxY - loc.getY());
        if (cc.debug) {
            System.out.println(player.getName() + " damage(FALL): " + damage + " / dist=" + player.getFallDistance() + " nf=" + data.noFallFallDistance + " yDiff=" + yDiff);
        }
        if ((maxD = NoFall.getDamage(Math.max(yDiff, Math.max(data.noFallFallDistance, fallDistance))) + (double)(allowReset ? 0 : 3)) > damage) {
            BridgeHealth.setDamage(event, maxD);
            if (cc.debug) {
                System.out.println(player.getName() + " Adjust fall damage to: " + maxD);
            }
        }
        if (allowReset) {
            data.clearNoFallData();
        } else {
            if (cc.noFallViolationReset) {
                data.clearNoFallData();
            }
            if (cc.sfHoverCheck && data.sfHoverTicks < 0) {
                data.sfHoverTicks = 0;
                this.hoverTicks.add(player.getName());
            }
        }
    }

    public void playerJoins(Player player) {
        int loaded;
        MovingData data = MovingData.getData(player);
        data.clearMorePacketsData();
        data.removeAllVelocity();
        Location loc = player.getLocation();
        if (loc == null) {
            data.clearFlyData();
        } else if (!data.hasSetBack()) {
            data.setSetBack(loc);
        } else if (data.hasSetBackWorldChanged(loc)) {
            data.clearFlyData();
            data.setSetBack(loc);
        }
        if (data.fromX == Double.MAX_VALUE && data.toX == Double.MAX_VALUE) {
            data.resetPositions(loc);
        }
        data.vDistAcc.clear();
        data.toWasReset = false;
        data.fromWasReset = false;
        MovingConfig cc = MovingConfig.getConfig(player);
        if (cc.sfHoverCheck) {
            data.sfHoverTicks = 0;
            data.sfHoverLoginTicks = cc.sfHoverLoginTicks;
            this.hoverTicks.add(player.getName());
        } else {
            data.sfHoverLoginTicks = 0;
            data.sfHoverTicks = -1;
        }
        if (cc.loadChunksOnJoin && (loaded = BlockCache.ensureChunksLoaded(loc.getWorld(), loc.getX(), loc.getZ(), 3.0)) > 0 && cc.debug && BuildParameters.debugLevel > 0) {
            LogUtil.logInfo("[NoCheatPlus] Player join: Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " for player: " + player.getName());
        }
    }

    public void playerLeaves(Player player) {
        this.survivalFly.setReallySneaking(player, false);
        this.noFall.onLeave(player);
        MovingData data = MovingData.getData(player);
        data.onPlayerLeave();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldunload(WorldUnloadEvent event) {
        MovingData.onWorldUnload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        LivingEntity entity = event.getExited();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Entity entity = event.getVehicle().getPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MovingData data = MovingData.getData(player);
        data.removeAllVelocity();
    }

    private final void onPlayerVehicleLeave(Player player) {
        MovingData data = MovingData.getData(player);
        data.wasInVehicle = false;
        Location loc = player.getLocation();
        if (BlockProperties.isLiquid(loc.getBlock().getTypeId())) {
            loc.setY((double)Location.locToBlock((double)loc.getY()) + 1.25);
        }
        data.resetPositions(loc);
        data.setSetBack(loc);
        data.removeAllVelocity();
        data.addHorizontalVelocity(new Velocity(0.9, 1, 1));
        data.verticalVelocityCounter = 1;
        data.verticalFreedom = 1.2;
        data.verticalVelocity = 0.15;
        data.verticalVelocityUsed = 0;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        this.survivalFly.setReallySneaking(event.getPlayer(), event.isSneaking());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (!event.isSprinting()) {
            MovingData.getData((Player)event.getPlayer()).timeSprinting = 0L;
        }
    }

    public final void onTick(int tick, long timeLast) {
        if (tick % this.hoverTicksStep != 0) {
            return;
        }
        MoveInfo info = this.parkedInfo.isEmpty() ? new MoveInfo(this.mcAccess) : this.parkedInfo.remove(this.parkedInfo.size() - 1);
        ArrayList<String> rem = new ArrayList<String>(this.hoverTicks.size());
        for (String playerName : this.hoverTicks) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            MovingData data = MovingData.getData(player);
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) {
                data.sfHoverTicks = -1;
            }
            if (data.sfHoverTicks < 0) {
                data.sfHoverLoginTicks = 0;
                rem.add(playerName);
                continue;
            }
            if (data.sfHoverLoginTicks > 0) {
                --data.sfHoverLoginTicks;
                continue;
            }
            MovingConfig cc = MovingConfig.getConfig(player);
            if (!cc.sfHoverCheck) {
                rem.add(playerName);
                data.sfHoverTicks = -1;
                continue;
            }
            data.sfHoverTicks += this.hoverTicksStep;
            if (data.sfHoverTicks < cc.sfHoverTicks || !this.checkHover(player, data, cc, info)) continue;
            rem.add(playerName);
        }
        info.cleanup();
        this.parkedInfo.add(info);
        this.hoverTicks.removeAll(rem);
        rem.clear();
    }

    private final boolean checkHover(Player player, MovingData data, MovingConfig cc, MoveInfo info) {
        boolean res;
        Location loc = player.getLocation();
        info.set(player, loc, null, cc.yOnGround);
        int loaded = info.from.ensureChunksLoaded();
        if (loaded > 0 && cc.debug && BuildParameters.debugLevel > 0) {
            LogUtil.logInfo("[NoCheatPlus] Hover check: Needed to load " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " around " + loc.getBlockX() + "," + loc.getBlockZ() + " in order to check player: " + player.getName());
        }
        if (info.from.isOnGround() || info.from.isResetCond() || info.from.isAboveLadder() || info.from.isAboveStairs()) {
            res = true;
            data.sfHoverTicks = 0;
        } else if (data.sfHoverTicks > cc.sfHoverTicks) {
            if (MovingListener.shouldCheckSurvivalFly(player, data, cc)) {
                this.handleHoverViolation(player, loc, cc, data);
                res = false;
                data.sfHoverTicks = 0;
            } else {
                res = false;
                data.sfHoverTicks = 0;
            }
        } else {
            res = false;
        }
        info.cleanup();
        return res;
    }

    private final void handleHoverViolation(Player player, Location loc, MovingConfig cc, MovingData data) {
        if (cc.sfHoverFallDamage && this.noFall.isEnabled(player)) {
            this.noFall.checkDamage(player, data, loc.getY());
        }
        this.survivalFly.handleHoverViolation(player, loc, cc, data);
    }

    public CheckType getCheckType() {
        return CheckType.MOVING_SURVIVALFLY;
    }

    public IData removeData(String playerName) {
        this.hoverTicks.remove(playerName);
        return null;
    }

    public void removeAllData() {
        this.hoverTicks.clear();
        this.parkedInfo.clear();
    }

    public void onReload() {
        for (MoveInfo info : this.parkedInfo) {
            info.cleanup();
        }
        this.parkedInfo.clear();
        this.hoverTicksStep = Math.max(1, ConfigManager.getConfigFile().getInt("checks.moving.survivalfly.hover.step"));
    }
}

