/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.TrigUtil;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Angle
extends Check {
    public Angle() {
        super(CheckType.FIGHT_ANGLE);
    }

    public boolean check(Player player, boolean worldChanged) {
        FightConfig cc = FightConfig.getConfig(player);
        FightData data = FightData.getData(player);
        if (worldChanged) {
            data.angleHits.clear();
        }
        boolean cancel = false;
        for (long time : new TreeMap<Long, Location>((SortedMap<Long, Location>)data.angleHits).navigableKeySet()) {
            if (System.currentTimeMillis() - time <= 1000L) continue;
            data.angleHits.remove(time);
        }
        data.angleHits.put(System.currentTimeMillis(), player.getLocation());
        if (data.angleHits.size() < 2) {
            return false;
        }
        double deltaMove = 0.0;
        long deltaTime = 0L;
        float deltaYaw = 0.0f;
        long previousTime = 0L;
        Location previousLocation = null;
        for (long time : data.angleHits.descendingKeySet()) {
            Location location = data.angleHits.get(time);
            if (previousLocation != null) {
                deltaMove += previousLocation.distanceSquared(location);
                deltaTime += previousTime - time;
                float dYaw = TrigUtil.yawDiff(previousLocation.getYaw(), location.getYaw());
                deltaYaw += Math.abs(dYaw);
            }
            previousTime = time;
            previousLocation = location;
        }
        double averageMove = deltaMove / (double)(data.angleHits.size() - 1);
        double averageTime = deltaTime / (long)(data.angleHits.size() - 1);
        double averageYaw = deltaYaw / (float)(data.angleHits.size() - 1);
        double violation = 0.0;
        if (averageMove > 0.0 && averageMove < 0.2) {
            violation += 200.0 * (0.2 - averageMove) / 0.2;
        }
        if (averageTime > 0.0 && averageTime < 150.0) {
            violation += 500.0 * (150.0 - averageTime) / 150.0;
        }
        if (averageYaw > 50.0) {
            violation += 300.0 * (360.0 - averageYaw) / 360.0;
        }
        if ((violation /= 10.0) > (double)cc.angleThreshold) {
            if (TickTask.getLag(1000L) < 1.5f) {
                data.angleVL += violation;
            }
            cancel = this.executeActions(player, data.angleVL, violation, cc.angleActions);
        } else {
            data.angleVL *= 0.98;
        }
        return cancel;
    }
}

