/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat.analysis.engine;

import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.EnginePlayerData;
import fr.neatmonster.nocheatplus.checks.chat.analysis.engine.processors.WordProcessor;
import fr.neatmonster.nocheatplus.utilities.ds.ManagedMap;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnginePlayerDataMap
extends ManagedMap<String, EnginePlayerData> {
    protected long durExpire;
    protected long lastAccess;
    protected long lastExpired;

    public EnginePlayerDataMap(long durExpire, int defaultCapacity, float loadFactor) {
        super(defaultCapacity, loadFactor);
        this.lastExpired = this.lastAccess = System.currentTimeMillis();
        this.durExpire = durExpire;
    }

    public EnginePlayerData get(String key, ChatConfig cc) {
        long ts;
        EnginePlayerData data = (EnginePlayerData)super.get((Object)key);
        if (data == null) {
            data = new EnginePlayerData(cc);
            this.put(key, data);
        }
        if ((ts = System.currentTimeMillis()) < this.lastExpired) {
            this.lastExpired = ts;
        } else if (ts - this.lastExpired > this.durExpire) {
            this.expire(ts - this.durExpire);
        }
        this.lastAccess = ts;
        return data;
    }

    public void clear() {
        long time = System.currentTimeMillis();
        for (ManagedMap.ValueWrap wrap : this.map.values()) {
            for (WordProcessor processor : ((EnginePlayerData)wrap.value).processors) {
                processor.clear();
            }
        }
        super.clear();
        this.lastAccess = this.lastExpired = time;
    }

    public Collection<String> expire(long ts) {
        Collection rem = super.expire(ts);
        if (!rem.isEmpty()) {
            this.lastExpired = System.currentTimeMillis();
        }
        return rem;
    }
}

