/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions;

import fr.neatmonster.nocheatplus.actions.AbstractActionFactory;
import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.types.CancelAction;
import fr.neatmonster.nocheatplus.actions.types.LogAction;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.logging.LogUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFactory
extends AbstractActionFactory<ViolationData, ActionList> {
    public ActionFactory(Map<String, Object> library) {
        super(library, ActionList.listFactory);
    }

    @Override
    public Action<ViolationData, ActionList> createAction(String actionDefinition) {
        if ((actionDefinition = actionDefinition.toLowerCase()).equals("cancel")) {
            return new CancelAction<ViolationData, ActionList>();
        }
        if (actionDefinition.startsWith("cmd:")) {
            return this.parseCmdAction(actionDefinition.split(":", 2)[1]);
        }
        if (actionDefinition.startsWith("log:")) {
            return this.parseLogAction(actionDefinition.split(":", 2)[1]);
        }
        throw new IllegalArgumentException("NoCheatPlus doesn't understand action '" + actionDefinition + "' at all");
    }

    protected Action<ViolationData, ActionList> parseLogAction(String definition) {
        String[] parts = definition.split(":");
        String name = parts[0];
        Object message = lib.get(parts[0]);
        int delay = 0;
        int repeat = 1;
        boolean toConsole = true;
        boolean toFile = true;
        boolean toChat = true;
        if (message == null) {
            throw new IllegalArgumentException("NoCheatPlus doesn't know log message '" + name + "'. Have you forgotten to define it?");
        }
        try {
            delay = Integer.parseInt(parts[1]);
            repeat = Integer.parseInt(parts[2]);
            toConsole = parts[3].contains("c");
            toChat = parts[3].contains("i");
            toFile = parts[3].contains("f");
        }
        catch (Exception e) {
            LogUtil.logWarning("[NoCheatPlus] Couldn't parse details of log action '" + definition + "', will use default values instead.");
            LogUtil.logWarning(e);
            delay = 0;
            repeat = 1;
            toConsole = true;
            toFile = true;
            toChat = true;
        }
        return new LogAction(name, delay, repeat, toChat, toConsole, toFile, message.toString());
    }
}

