/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordMap<V> {
    private static final int p1 = 73856093;
    private static final int p2 = 19349663;
    private static final int p3 = 83492791;
    private final float loadFactor;
    private List<Entry<V>>[] entries;
    private int size = 0;

    private static final int getHash(int x, int y, int z) {
        return 73856093 * x ^ 19349663 * y ^ 83492791 * z;
    }

    public CoordMap() {
        this(10, 0.75f);
    }

    public CoordMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CoordMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.entries = new List[initialCapacity];
    }

    public final boolean contains(int x, int y, int z) {
        return this.get(x, y, z) != null;
    }

    public final V get(int x, int y, int z) {
        int hash = CoordMap.getHash(x, y, z);
        int slot = Math.abs(hash) % this.entries.length;
        List<Entry<V>> bucket = this.entries[slot];
        if (bucket == null) {
            return null;
        }
        for (Entry<V> entry : bucket) {
            if (hash != entry.hash || x != entry.x || z != entry.z || y != entry.y) continue;
            return entry.value;
        }
        return null;
    }

    public final boolean put(int x, int y, int z, V value) {
        int hash = CoordMap.getHash(x, y, z);
        int absHash = Math.abs(hash);
        int slot = absHash % this.entries.length;
        List<Entry<V>> bucket = this.entries[slot];
        if (bucket != null) {
            for (Entry<V> entry : bucket) {
                if (hash != entry.hash || x != entry.x || z != entry.z || y != entry.y) continue;
                entry.value = value;
                return true;
            }
        } else if ((float)(this.size + 1) > (float)this.entries.length * this.loadFactor) {
            this.resize(this.size + 1);
            slot = absHash % this.entries.length;
            bucket = this.entries[slot];
        }
        if (bucket == null) {
            bucket = new LinkedList<Entry<V>>();
            this.entries[slot] = bucket;
        }
        bucket.add(new Entry<V>(x, y, z, value, hash));
        ++this.size;
        return false;
    }

    public final V remove(int x, int y, int z) {
        int hash = CoordMap.getHash(x, y, z);
        int absHash = Math.abs(hash);
        int slot = absHash % this.entries.length;
        List<Entry<V>> bucket = this.entries[slot];
        if (bucket == null) {
            return null;
        }
        for (int i = 0; i < bucket.size(); ++i) {
            Entry<V> entry = bucket.get(i);
            if (entry.hash != hash || x != entry.x || z != entry.z || y != entry.y) continue;
            bucket.remove(entry);
            if (bucket.isEmpty()) {
                this.entries[slot] = null;
            }
            --this.size;
            return entry.value;
        }
        return null;
    }

    private final void resize(int size) {
        int newCapacity = Math.min(Math.max((int)((float)(size + 4) / this.loadFactor), this.entries.length + this.entries.length / 4), 4);
        List[] newEntries = new List[newCapacity];
        int used = -1;
        for (int oldSlot = 0; oldSlot < this.entries.length; ++oldSlot) {
            List<Entry<V>> oldBucket = this.entries[oldSlot];
            if (oldBucket == null) continue;
            for (Entry<V> entry : oldBucket) {
                int newSlot = Math.abs(entry.hash) % newCapacity;
                List<Entry<V>> newBucket = newEntries[newSlot];
                if (newBucket == null) {
                    if (used < 0) {
                        newBucket = new LinkedList<Entry<V>>();
                    } else {
                        newBucket = this.entries[used];
                        this.entries[used] = null;
                        --used;
                    }
                    newEntries[newSlot] = newBucket;
                }
                newBucket.add(entry);
            }
            oldBucket.clear();
            this.entries[oldSlot] = null;
            this.entries[++used] = oldBucket;
        }
        this.entries = newEntries;
    }

    public final int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.entries, null);
    }

    public final Iterator<Entry<V>> iterator() {
        return new CoordMapIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CoordMapIterator<V>
    implements Iterator<Entry<V>> {
        private final CoordMap<V> map;
        private final List<Entry<V>>[] entries;
        private int slot = 0;
        private int index = 0;
        private int slotLast = -1;
        private int indexLast = -1;

        protected CoordMapIterator(CoordMap<V> map) {
            this.map = map;
            this.entries = ((CoordMap)map).entries;
        }

        @Override
        public final boolean hasNext() {
            while (this.slot < this.entries.length) {
                List<Entry<V>> bucket = this.entries[this.slot];
                if (bucket == null) {
                    ++this.slot;
                    this.index = 0;
                    continue;
                }
                if (this.index < bucket.size()) {
                    return true;
                }
                ++this.slot;
                this.index = 0;
            }
            return false;
        }

        @Override
        public final Entry<V> next() {
            while (this.slot < this.entries.length) {
                List<Entry<V>> bucket = this.entries[this.slot];
                if (bucket == null) {
                    ++this.slot;
                    this.index = 0;
                    continue;
                }
                int size = bucket.size();
                if (this.index < size) {
                    Entry<V> res = bucket.get(this.index);
                    this.slotLast = this.slot++;
                    this.indexLast = this.index++;
                    if (this.index == size) {
                        this.index = 0;
                    }
                    return res;
                }
                ++this.slot;
                this.index = 0;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            if (this.slotLast == -1) {
                return;
            }
            List<Entry<V>> bucket = this.entries[this.slotLast];
            bucket.remove(this.indexLast);
            if (bucket.isEmpty()) {
                this.entries[this.slotLast] = null;
            } else if (this.slotLast == this.slot) {
                --this.index;
            }
            ((CoordMap)this.map).size--;
            this.indexLast = -1;
            this.slotLast = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry<V> {
        protected final int x;
        protected final int y;
        protected final int z;
        protected V value;
        protected final int hash;

        public Entry(int x, int y, int z, V value, int hash) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.value = value;
            this.hash = hash;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        public final V getValue() {
            return this.value;
        }
    }
}

