/*
 * Decompiled with CFR 0.152.
 */
package fr.minuskube.netherboard.bukkit;

import fr.minuskube.netherboard.Netherboard;
import fr.minuskube.netherboard.api.PlayerBoard;
import fr.minuskube.netherboard.bukkit.util.NMS;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlayerBoard
implements PlayerBoard<String, Integer, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BPlayerBoard.class);
    private Player player;
    private Scoreboard scoreboard;
    private String name;
    private Objective objective;
    private Objective buffer;
    private Map<Integer, String> lines = new HashMap<Integer, String>();
    private boolean deleted = false;

    public BPlayerBoard(Player player, String name) {
        this(player, null, name);
    }

    public BPlayerBoard(Player player, Scoreboard scoreboard, String name) {
        this.player = player;
        this.scoreboard = scoreboard;
        if (this.scoreboard == null) {
            Scoreboard sb = player.getScoreboard();
            if (sb == null || sb == Bukkit.getScoreboardManager().getMainScoreboard()) {
                sb = Bukkit.getScoreboardManager().getNewScoreboard();
            }
            this.scoreboard = sb;
        }
        this.name = name;
        String subName = player.getName().length() <= 14 ? player.getName() : player.getName().substring(0, 14);
        this.objective = this.scoreboard.getObjective("sb" + subName);
        this.buffer = this.scoreboard.getObjective("bf" + subName);
        if (this.objective == null) {
            this.objective = this.scoreboard.registerNewObjective("sb" + subName, "dummy");
        }
        if (this.buffer == null) {
            this.buffer = this.scoreboard.registerNewObjective("bf" + subName, "dummy");
        }
        this.objective.setDisplayName(name);
        this.sendObjective(this.objective, ObjectiveMode.CREATE);
        this.sendObjectiveDisplay(this.objective);
        this.buffer.setDisplayName(name);
        this.sendObjective(this.buffer, ObjectiveMode.CREATE);
        this.player.setScoreboard(this.scoreboard);
    }

    public String get(Integer score) {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        return this.lines.get(score);
    }

    public void set(String name, Integer score) {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        String oldName = this.lines.get(score);
        if (name.equals(oldName)) {
            return;
        }
        this.lines.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(name));
        if (oldName != null) {
            if (NMS.getVersion().getMajor().equals("1.7")) {
                this.sendScore(this.objective, oldName, score, true);
                this.sendScore(this.objective, name, score, false);
            } else {
                this.sendScore(this.buffer, oldName, score, true);
                this.sendScore(this.buffer, name, score, false);
                this.swapBuffers();
                this.sendScore(this.buffer, oldName, score, true);
                this.sendScore(this.buffer, name, score, false);
            }
        } else {
            this.sendScore(this.objective, name, score, false);
            this.sendScore(this.buffer, name, score, false);
        }
        this.lines.put(score, name);
    }

    public void setAll(String ... lines) {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            this.set(line, lines.length - i);
        }
        HashSet<Integer> scores = new HashSet<Integer>(this.lines.keySet());
        Iterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            int score = (Integer)iterator.next();
            if (score > 0 && score <= lines.length) continue;
            this.remove(score);
        }
    }

    public void clear() {
        new HashSet<Integer>(this.lines.keySet()).forEach(this::remove);
        this.lines.clear();
    }

    private void swapBuffers() {
        this.sendObjectiveDisplay(this.buffer);
        Objective temp = this.buffer;
        this.buffer = this.objective;
        this.objective = temp;
    }

    private void sendObjective(Objective obj, ObjectiveMode mode) {
        try {
            Object objHandle = NMS.getHandle(obj);
            Object packetObj = NMS.PACKET_OBJ.newInstance(objHandle, mode.ordinal());
            NMS.sendPacket(packetObj, this.player);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating and sending objective packet. (Unsupported Minecraft version?)", (Throwable)e);
        }
    }

    private void sendObjectiveDisplay(Objective obj) {
        try {
            Object objHandle = NMS.getHandle(obj);
            Object packet = NMS.PACKET_DISPLAY.newInstance(1, objHandle);
            NMS.sendPacket(packet, this.player);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating and sending display packet. (Unsupported Minecraft version?)", (Throwable)e);
        }
    }

    private void sendScore(Objective obj, String name, int score, boolean remove) {
        try {
            Object sbHandle = NMS.getHandle(this.scoreboard);
            Object objHandle = NMS.getHandle(obj);
            Object sbScore = NMS.SB_SCORE.newInstance(sbHandle, objHandle, name);
            NMS.SB_SCORE_SET.invoke(sbScore, score);
            Map scores = (Map)NMS.PLAYER_SCORES.get(sbHandle);
            if (remove) {
                if (scores.containsKey(name)) {
                    ((Map)scores.get(name)).remove(objHandle);
                }
            } else {
                if (!scores.containsKey(name)) {
                    scores.put(name, new HashMap());
                }
                ((Map)scores.get(name)).put(objHandle, sbScore);
            }
            switch (NMS.getVersion().getMajor()) {
                case "1.7": {
                    Object packet = NMS.PACKET_SCORE.newInstance(sbScore, remove ? 1 : 0);
                    NMS.sendPacket(packet, this.player);
                    break;
                }
                case "1.8": 
                case "1.9": 
                case "1.10": 
                case "1.11": 
                case "1.12": {
                    Object packet = remove ? NMS.PACKET_SCORE_REMOVE.newInstance(name, objHandle) : NMS.PACKET_SCORE.newInstance(sbScore);
                    NMS.sendPacket(packet, this.player);
                    break;
                }
                default: {
                    Object packet = NMS.PACKET_SCORE.newInstance(remove ? NMS.ENUM_SCORE_ACTION_REMOVE : NMS.ENUM_SCORE_ACTION_CHANGE, obj.getName(), name, score);
                    NMS.sendPacket(packet, this.player);
                    break;
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Error while creating and sending remove packet. (Unsupported Minecraft version?)", (Throwable)e);
        }
    }

    public void remove(Integer score) {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        String name = this.lines.get(score);
        if (name == null) {
            return;
        }
        this.scoreboard.resetScores(name);
        this.lines.remove(score);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        Netherboard.instance().removeBoard(this.player);
        this.sendObjective(this.objective, ObjectiveMode.REMOVE);
        this.sendObjective(this.buffer, ObjectiveMode.REMOVE);
        this.objective.unregister();
        this.objective = null;
        this.buffer.unregister();
        this.buffer = null;
        this.lines = null;
        this.deleted = true;
    }

    public Map<Integer, String> getLines() {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        return new HashMap<Integer, String>(this.lines);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.deleted) {
            throw new IllegalStateException("The PlayerBoard is deleted!");
        }
        this.name = name;
        this.objective.setDisplayName(name);
        this.buffer.setDisplayName(name);
        this.sendObjective(this.objective, ObjectiveMode.UPDATE);
        this.sendObjective(this.buffer, ObjectiveMode.UPDATE);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    private static enum ObjectiveMode {
        CREATE,
        REMOVE,
        UPDATE;

    }
}

