/*
 * Decompiled with CFR 0.152.
 */
package fr.minuskube.netherboard.bukkit.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMS {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMS.class);
    private static String packageName;
    private static Version version;
    public static final Field PLAYER_SCORES;
    public static final Constructor<?> PACKET_SCORE_REMOVE;
    public static final Constructor<?> PACKET_SCORE;
    public static final Object ENUM_SCORE_ACTION_CHANGE;
    public static final Object ENUM_SCORE_ACTION_REMOVE;
    public static final Constructor<?> SB_SCORE;
    public static final Method SB_SCORE_SET;
    public static final Constructor<?> PACKET_OBJ;
    public static final Constructor<?> PACKET_DISPLAY;
    public static final Field PLAYER_CONNECTION;
    public static final Method SEND_PACKET;
    private static Map<Class<?>, Method> handles;

    public static Version getVersion() {
        return version;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(packageName + "." + name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object getHandle(Object obj) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = obj.getClass();
        if (!handles.containsKey(clazz)) {
            Method method = clazz.getDeclaredMethod("getHandle", new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            handles.put(clazz, method);
        }
        return handles.get(clazz).invoke(obj, new Object[0]);
    }

    public static void sendPacket(Object packet, Player ... players) {
        for (Player p : players) {
            try {
                Object playerConnection = PLAYER_CONNECTION.get(NMS.getHandle(p));
                SEND_PACKET.invoke(playerConnection, packet);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while sending packet to player. (Unsupported Minecraft version?)", (Throwable)e);
            }
        }
    }

    static {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String ver = name.substring(name.lastIndexOf(46) + 1);
        version = new Version(ver);
        packageName = "net.minecraft.server." + ver;
        Field playerScores = null;
        Constructor<?> packetScoreRemove = null;
        Constructor<?> packetScore = null;
        Object enumScoreActionChange = null;
        Object enumScoreActionRemove = null;
        Constructor<?> sbScore = null;
        Method sbScoreSet = null;
        Constructor<?> packetObj = null;
        Constructor<?> packetDisplay = null;
        Field playerConnection = null;
        Method sendPacket = null;
        try {
            Class<?> packetScoreClass = NMS.getClass("PacketPlayOutScoreboardScore");
            Class<?> packetDisplayClass = NMS.getClass("PacketPlayOutScoreboardDisplayObjective");
            Class<?> packetObjClass = NMS.getClass("PacketPlayOutScoreboardObjective");
            Class<?> scoreClass = NMS.getClass("ScoreboardScore");
            Class<?> scoreActionClass = NMS.getClass("ScoreboardServer$Action");
            Class<?> sbClass = NMS.getClass("Scoreboard");
            Class<?> objClass = NMS.getClass("ScoreboardObjective");
            Class<?> playerClass = NMS.getClass("EntityPlayer");
            Class<?> playerConnectionClass = NMS.getClass("PlayerConnection");
            Class<?> packetClass = NMS.getClass("Packet");
            playerScores = sbClass.getDeclaredField("playerScores");
            playerScores.setAccessible(true);
            sbScore = scoreClass.getConstructor(sbClass, objClass, String.class);
            sbScoreSet = scoreClass.getMethod("setScore", Integer.TYPE);
            packetObj = packetObjClass.getConstructor(objClass, Integer.TYPE);
            switch (version.getMajor()) {
                case "1.7": {
                    packetScore = packetScoreClass.getConstructor(scoreClass, Integer.TYPE);
                    break;
                }
                case "1.8": 
                case "1.9": 
                case "1.10": 
                case "1.11": 
                case "1.12": {
                    packetScore = packetScoreClass.getConstructor(scoreClass);
                    packetScoreRemove = packetScoreClass.getConstructor(String.class, objClass);
                    break;
                }
                default: {
                    packetScore = packetScoreClass.getConstructor(scoreActionClass, String.class, String.class, Integer.TYPE);
                    enumScoreActionChange = scoreActionClass.getEnumConstants()[0];
                    enumScoreActionRemove = scoreActionClass.getEnumConstants()[1];
                }
            }
            packetDisplay = packetDisplayClass.getConstructor(Integer.TYPE, objClass);
            playerConnection = playerClass.getField("playerConnection");
            sendPacket = playerConnectionClass.getMethod("sendPacket", packetClass);
        }
        catch (Exception e) {
            LOGGER.error("Error while loading NMS methods. (Unsupported Minecraft version?)", (Throwable)e);
        }
        PLAYER_SCORES = playerScores;
        PACKET_SCORE_REMOVE = packetScoreRemove;
        PACKET_SCORE = packetScore;
        ENUM_SCORE_ACTION_CHANGE = enumScoreActionChange;
        ENUM_SCORE_ACTION_REMOVE = enumScoreActionRemove;
        SB_SCORE = sbScore;
        SB_SCORE_SET = sbScoreSet;
        PACKET_OBJ = packetObj;
        PACKET_DISPLAY = packetDisplay;
        PLAYER_CONNECTION = playerConnection;
        SEND_PACKET = sendPacket;
        handles = new HashMap();
    }

    public static class Version {
        private String name;
        private String major;
        private String minor;

        Version(String name) {
            this.name = name;
            String[] splitted = name.split("_");
            this.major = splitted[0].substring(1) + "." + splitted[1];
            this.minor = splitted[2].substring(1);
        }

        public String getName() {
            return this.name;
        }

        public String getMajor() {
            return this.major;
        }

        public String getMinor() {
            return this.minor;
        }
    }
}

