/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.skype;

import fr.delthas.skype.Presence;
import fr.delthas.skype.Skype;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class User {
    private final Skype skype;
    private final String username;
    private String firstname;
    private String lastname;
    private String mood;
    private String country;
    private String city;
    private String displayName;
    private String avatarUrl;
    private Presence presence = Presence.OFFLINE;

    User(Skype skype, String username) {
        this.skype = skype;
        this.username = username;
    }

    public void block() {
        this.skype.block(this);
    }

    public void unblock() {
        this.skype.unblock(this);
    }

    public void sendContactRequest(String greeting) {
        this.skype.sendContactRequest(this, greeting);
    }

    public void removeFromContacts() {
        this.skype.removeFromContacts(this);
    }

    public void sendMessage(String message) {
        this.skype.sendUserMessage(this, message);
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.firstname != null) {
            if (this.lastname != null) {
                return this.firstname + " " + this.lastname;
            }
            return this.firstname;
        }
        return this.username;
    }

    void setDisplayName(String displayName) {
        if (displayName == null || displayName.isEmpty()) {
            return;
        }
        this.displayName = displayName;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getMood() {
        return this.mood;
    }

    void setMood(String mood) {
        if (mood == null || mood.isEmpty()) {
            return;
        }
        this.mood = mood;
    }

    public String getCountry() {
        return this.country;
    }

    void setCountry(String country) {
        if (country == null || country.isEmpty()) {
            return;
        }
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    void setCity(String city) {
        if (city == null || city.isEmpty()) {
            return;
        }
        this.city = city;
    }

    public byte[] getAvatar() {
        return this.skype.getAvatar(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getAvatarImage() {
        byte[] bytes = this.getAvatar();
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    void setAvatarUrl(String avatarUrl) {
        if (avatarUrl == null || avatarUrl.isEmpty()) {
            return;
        }
        this.avatarUrl = avatarUrl;
    }

    public Presence getPresence() {
        return this.presence;
    }

    void setPresence(String presenceString) {
        this.setPresence(Presence.getPresence(presenceString), true);
    }

    void setPresence(Presence presence) {
        this.setPresence(presence, true);
    }

    void setFirstName(String firstname) {
        if (firstname == null || firstname.isEmpty()) {
            return;
        }
        this.firstname = firstname;
    }

    void setLastName(String lastname) {
        if (lastname == null || lastname.isEmpty()) {
            return;
        }
        this.lastname = lastname;
    }

    void setPresence(Presence presence, boolean triggerListeners) {
        if (presence != this.presence) {
            Presence oldPresence = this.presence;
            this.presence = presence;
            if (triggerListeners) {
                this.skype.userPresenceChanged(this, oldPresence, presence);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "User: " + this.getUsername();
    }
}

