/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.skype;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class UicConnector {
    private static final Logger logger;
    private static final Random random;
    private static final String[] servers;
    private static final int port = 33033;
    private static final String skypePublicKeyModulus = "a8f223612f4f5fc81ef1ca5e310b0b21532a72df6c1af0fbec87304aec983aab5d74a14cc72e53ef7752a248c0e5abe09484b597692015e796350989c88b3cae140ca82ccd9914e540468cf0edb35dcba4c352890e7a9eafac550b3978627651ad0a804f385ef5f4093ac6ee66b23e1f8202c61c6c0375eeb713852397ced2e199492aa61a3eab163d4c2625c873e95cafd95b80dd2d8732c8e25638a2007acfa6c8f1ff31cc2bc4ca8f4446f51da404335a48c955aaa3a4b57250d7ba29700b";
    private static final int[] crc32_tab;

    private UicConnector() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    public static String getUIC(String username, String password, String nonce) throws IOException, GeneralSecurityException {
        int challengePosition;
        byte[] mac;
        logger.finest("Computing UIC token with username: " + username + " and nonce: " + nonce);
        byte[] sessionKey = new byte[192];
        random.nextBytes(sessionKey);
        sessionKey[0] = 1;
        byte[] magic = new byte[]{22, 3, 1};
        byte[] magicResponse = new byte[]{23, 3, 1};
        Socket socket = null;
        DataInputStream dis = null;
        DataOutputStream dos = null;
        for (String server : servers) {
            try {
                socket = new Socket(server, 33033);
                dos = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                dos.write(magic);
                dos.writeShort(0);
                dos.flush();
                dis = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
                byte[] response = new byte[3];
                dis.readFully(response);
                if (Arrays.equals(magicResponse, response)) {
                    dis.readFully(response, 0, 2);
                    break;
                }
                logger.fine("Wrong magic received from server during handshake");
                socket.close();
                socket = null;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Failed connecting to server " + server + " for handshake", ex);
            }
        }
        if (socket == null) {
            logger.severe("No server responded (correctly) to handshake");
            return null;
        }
        KeyPairGenerator pairGenerator = KeyPairGenerator.getInstance("RSA");
        pairGenerator.initialize(new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4));
        KeyPair keyPair = pairGenerator.generateKeyPair();
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/NOPADDING");
        Cipher aesCipher = Cipher.getInstance("AES/CTR/NOPADDING");
        MessageDigest shaCrypt = MessageDigest.getInstance("SHA-1");
        MessageDigest md5Crypt = MessageDigest.getInstance("MD5");
        dos.write(magic);
        dos.writeShort(205);
        dos.writeByte(65);
        dos.writeByte(3);
        UicConnector.writeValue(dos, 0);
        UicConnector.writeValue(dos, 9);
        UicConnector.writeValue(dos, 8192);
        byte[] sha = new byte[32];
        shaCrypt.reset();
        shaCrypt.update(new byte[]{0, 0, 0, 0});
        shaCrypt.update(sessionKey);
        System.arraycopy(shaCrypt.digest(), 0, sha, 0, 20);
        shaCrypt.update(new byte[]{0, 0, 0, 1});
        shaCrypt.update(sessionKey);
        System.arraycopy(shaCrypt.digest(), 0, sha, 20, 12);
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger(skypePublicKeyModulus, 16), BigInteger.valueOf(65537L)));
        rsaCipher.init(1, publicKey);
        byte[] encryptedSessionKey = rsaCipher.doFinal(sessionKey);
        UicConnector.writeValue(dos, 4);
        UicConnector.writeValue(dos, 8);
        UicConnector.writeValue(dos, 192);
        dos.write(encryptedSessionKey, 0, 192);
        UicConnector.writeValue(dos, 0);
        UicConnector.writeValue(dos, 12);
        UicConnector.writeValue(dos, 1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream sink = new DataOutputStream(baos);
        sink.writeByte(65);
        sink.writeByte(4);
        UicConnector.writeValue(sink, 0);
        UicConnector.writeValue(sink, 0);
        UicConnector.writeValue(sink, 5017);
        UicConnector.writeValue(sink, 0);
        UicConnector.writeValue(sink, 2);
        UicConnector.writeValue(sink, 1);
        UicConnector.writeValue(sink, 3);
        UicConnector.writeValue(sink, 4);
        sink.write(username.getBytes(StandardCharsets.UTF_8));
        sink.writeByte(0);
        md5Crypt.reset();
        md5Crypt.update(username.getBytes(StandardCharsets.UTF_8));
        md5Crypt.update("\nskyper\n".getBytes(StandardCharsets.UTF_8));
        md5Crypt.update(password.getBytes(StandardCharsets.UTF_8));
        byte[] loginHash = md5Crypt.digest();
        UicConnector.writeValue(sink, 4);
        UicConnector.writeValue(sink, 5);
        UicConnector.writeValue(sink, 16);
        sink.write(loginHash, 0, 16);
        sink.writeByte(65);
        sink.writeByte(6);
        UicConnector.writeValue(sink, 4);
        UicConnector.writeValue(sink, 33);
        UicConnector.writeValue(sink, 128);
        byte[] publicModulus = ((RSAPublicKey)keyPair.getPublic()).getModulus().abs().toByteArray();
        sink.write(publicModulus, publicModulus.length - 128, 128);
        UicConnector.writeValue(sink, 1);
        UicConnector.writeValue(sink, 49);
        NetworkInterface n = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        if (n != null && (mac = n.getHardwareAddress()) != null) {
            shaCrypt.reset();
            shaCrypt.update(mac);
            sink.write(shaCrypt.digest(), 0, 8);
        } else {
            sink.writeLong(random.nextLong());
        }
        UicConnector.writeValue(sink, 3);
        UicConnector.writeValue(sink, 54);
        sink.write("en".getBytes(StandardCharsets.UTF_8));
        sink.writeByte(0);
        UicConnector.writeValue(sink, 6);
        UicConnector.writeValue(sink, 51);
        UicConnector.writeValue(sink, 5);
        for (int i = 0; i < 5; ++i) {
            sink.writeByte(0);
        }
        UicConnector.writeValue(sink, 3);
        UicConnector.writeValue(sink, 13);
        sink.write("0/7.44.0.104".getBytes(StandardCharsets.UTF_8));
        sink.writeByte(0);
        UicConnector.writeValue(sink, 0);
        UicConnector.writeValue(sink, 14);
        UicConnector.writeValue(sink, 2130706433);
        byte[] bytes = baos.toByteArray();
        dos.write(magicResponse);
        dos.writeShort(bytes.length + 2);
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        aesCipher.init(1, (Key)new SecretKeySpec(sha, "AES"), new IvParameterSpec(iv));
        byte[] encrypted = aesCipher.doFinal(bytes);
        dos.write(encrypted);
        int crc = -1;
        for (int i = 0; i < encrypted.length; ++i) {
            crc = crc32_tab[(crc ^ encrypted[i]) & 0xFF] ^ crc >>> 8;
        }
        dos.writeByte((byte)crc);
        dos.writeByte((byte)(crc >>> 8));
        dos.flush();
        logger.finest("Sent UIC payload to server");
        byte[] response = new byte[3];
        dis.readFully(response);
        if (!Arrays.equals(magicResponse, response)) {
            socket.close();
            logger.severe("Wrong magic received from server after payload");
            return null;
        }
        int size = dis.readShort() - 2;
        byte[] received = new byte[size];
        dis.readFully(received);
        iv[3] = 1;
        iv[7] = 1;
        aesCipher.init(2, (Key)new SecretKeySpec(sha, "AES"), new IvParameterSpec(iv));
        byte[] decrypted = aesCipher.doFinal(received);
        byte[] signedCredentials = null;
        int[] position = new int[]{0};
        block9: while (position[0] < decrypted.length) {
            position[0] = position[0] + 1;
            int numberObjects = UicConnector.readValue(decrypted, position);
            block10: for (int i = 0; i < numberObjects; ++i) {
                int n2 = position[0];
                position[0] = n2 + 1;
                byte family = decrypted[n2];
                int id = UicConnector.readValue(decrypted, position);
                switch (family) {
                    case 0: {
                        int value = UicConnector.readValue(decrypted, position);
                        if (id != 1 || value == 4200) continue block10;
                        logger.severe("Received LOGIN_CODE != LOGIN_OK: received code " + value);
                        break block9;
                    }
                    case 4: {
                        int blobSize = UicConnector.readValue(decrypted, position);
                        if (id == 36) {
                            signedCredentials = new byte[blobSize];
                            System.arraycopy(decrypted, position[0], signedCredentials, 0, blobSize);
                            break block9;
                        }
                        position[0] = position[0] + blobSize;
                        continue block10;
                    }
                    default: {
                        break block9;
                    }
                }
            }
        }
        socket.close();
        if (signedCredentials == null) {
            logger.severe("No credentials received after payload");
            return null;
        }
        byte[] salt = "WS-SecureConversationSESSION KEY TOKEN".getBytes(StandardCharsets.UTF_8);
        byte[] nonceBytes = nonce.getBytes(StandardCharsets.UTF_8);
        byte[] challenge = new byte[20 + salt.length + nonceBytes.length];
        shaCrypt.reset();
        shaCrypt.update(signedCredentials);
        shaCrypt.update(salt);
        System.arraycopy(shaCrypt.digest(), 0, challenge, 0, 20);
        System.arraycopy(salt, 0, challenge, 20, salt.length);
        System.arraycopy(nonceBytes, 0, challenge, 20 + salt.length, nonceBytes.length);
        byte[] challengeSigned = new byte[128];
        challengeSigned[0] = 75;
        for (challengePosition = 1; challengePosition < 128 - challenge.length - 20 - 2; ++challengePosition) {
            challengeSigned[challengePosition] = -69;
        }
        challengeSigned[challengePosition++] = -70;
        System.arraycopy(challenge, 0, challengeSigned, challengePosition, challenge.length);
        shaCrypt.reset();
        shaCrypt.update(challenge);
        System.arraycopy(shaCrypt.digest(), 0, challengeSigned, challengePosition += challenge.length, 20);
        challengeSigned[challengePosition += 20] = -68;
        byte[] challengeEncrypted = new byte[challengeSigned.length + 4 + signedCredentials.length];
        challengeEncrypted[0] = (byte)(signedCredentials.length >> 24);
        challengeEncrypted[1] = (byte)(signedCredentials.length >> 16);
        challengeEncrypted[2] = (byte)(signedCredentials.length >> 8);
        challengeEncrypted[3] = (byte)signedCredentials.length;
        System.arraycopy(signedCredentials, 0, challengeEncrypted, 4, signedCredentials.length);
        rsaCipher.init(1, keyPair.getPrivate());
        rsaCipher.doFinal(challengeSigned, 0, challengeSigned.length, challengeEncrypted, 4 + signedCredentials.length);
        String uic = new String(Base64.getEncoder().encode(challengeEncrypted), StandardCharsets.UTF_8);
        logger.finest("Computed UIC succesfully (uic length:" + uic.length() + ")");
        return uic;
    }

    private static int readValue(byte[] bytes, int[] position) {
        int result = 0;
        for (int a = 0; a == 0 || (bytes[position[0] - 1] & 0x80) != 0; a += 7) {
            result |= (bytes[position[0]] & 0x7F) << a;
            position[0] = position[0] + 1;
        }
        return result;
    }

    private static void writeValue(DataOutputStream dos, int value) throws IOException {
        int a;
        for (a = value; a > 127; a >>>= 7) {
            dos.writeByte(a & 0x7F | 0x80);
        }
        dos.writeByte(a & 0x7F);
    }

    static {
        int newMaxKeyLength;
        logger = Logger.getLogger("fr.delthas.skype.uic");
        random = new Random();
        servers = new String[]{"91.190.216.17", "91.190.218.40"};
        crc32_tab = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
        String errorString = "Failed manually overriding key-length permissions. Please open an issue at https://github.com/Delthas/JavaSkype/issues/ if you see this message. Try doing this to fix the problem: http://stackoverflow.com/a/3864276";
        logger.finest("Initializing UIC generation");
        try {
            newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (newMaxKeyLength < 256) {
                logger.finer("Overriding AES key length because of limitation");
                Class<?> c = Class.forName("javax.crypto.CryptoAllPermissionCollection");
                Constructor<?> con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissionCollection = con.newInstance(new Object[0]);
                Field f = c.getDeclaredField("all_allowed");
                f.setAccessible(true);
                f.setBoolean(allPermissionCollection, true);
                c = Class.forName("javax.crypto.CryptoPermissions");
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissions = con.newInstance(new Object[0]);
                f = c.getDeclaredField("perms");
                f.setAccessible(true);
                ((Map)f.get(allPermissions)).put("*", allPermissionCollection);
                c = Class.forName("javax.crypto.JceSecurityManager");
                f = c.getDeclaredField("defaultPolicy");
                f.setAccessible(true);
                Field mf = Field.class.getDeclaredField("modifiers");
                mf.setAccessible(true);
                mf.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(null, allPermissions);
                newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            } else {
                logger.finest("Not overriding AES key length");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error when overriding AES key length", e);
            throw new RuntimeException(errorString, e);
        }
        if (newMaxKeyLength < 256) {
            logger.severe("Failed overriding AES key length");
            throw new RuntimeException(errorString);
        }
    }
}

