/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.skype;

import fr.delthas.skype.FormattedMessage;
import fr.delthas.skype.Group;
import fr.delthas.skype.Pair;
import fr.delthas.skype.ParseException;
import fr.delthas.skype.Presence;
import fr.delthas.skype.Role;
import fr.delthas.skype.Skype;
import fr.delthas.skype.UicConnector;
import fr.delthas.skype.User;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class NotifConnector {
    private static final Logger logger = Logger.getLogger("fr.delthas.skype.notif");
    private static final String EPID = NotifConnector.generateEPID();
    private static final String DEFAULT_SERVER_HOSTNAME = "s.gateway.messenger.live.com";
    private static final int DEFAULT_SERVER_PORT = 443;
    private static final Pattern patternFirstLine = Pattern.compile("([A-Z]+|\\d+) \\d+ ([A-Z]+(?:\\\\[A-Z]+)?) (\\d+)");
    private static final Pattern patternHeaders = Pattern.compile("\\A(?:(?:Set-Registration: (.+)|[A-Za-z\\-]+: .+)\\R)*\\R");
    private static final Pattern patternXFR = Pattern.compile("([a-zA-Z0-9\\.\\-]+):(\\d+)");
    private static final long pingInterval = 120000000000L;
    private final DocumentBuilder documentBuilder;
    private final Skype skype;
    private final String username;
    private final String password;
    private long lastMessageSentTime;
    private Thread pingThread;
    private boolean disconnectRequested = false;
    private Socket socket;
    private BufferedWriter writer;
    private BufferedInputStream inputStream;
    private int sequenceNumber;
    private String registration;
    private CountDownLatch connectLatch = new CountDownLatch(1);

    public NotifConnector(Skype skype, String username, String password) {
        this.skype = skype;
        this.username = username;
        this.password = password;
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String generateEPID() {
        int i;
        char[] hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] EPIDchars = new char[36];
        EPIDchars[8] = 45;
        EPIDchars[13] = 45;
        EPIDchars[18] = 45;
        EPIDchars[23] = 45;
        Random random = new Random();
        for (i = 0; i < 8; ++i) {
            EPIDchars[i] = hexCharacters[random.nextInt(hexCharacters.length)];
        }
        for (i = 9; i < 13; ++i) {
            EPIDchars[i] = hexCharacters[random.nextInt(hexCharacters.length)];
        }
        for (i = 14; i < 18; ++i) {
            EPIDchars[i] = hexCharacters[random.nextInt(hexCharacters.length)];
        }
        for (i = 19; i < 23; ++i) {
            EPIDchars[i] = hexCharacters[random.nextInt(hexCharacters.length)];
        }
        for (i = 24; i < 36; ++i) {
            EPIDchars[i] = hexCharacters[random.nextInt(hexCharacters.length)];
        }
        String EPID = new String(EPIDchars);
        logger.finest("Generated EPID: " + EPID);
        return EPID;
    }

    private static String getPlaintext(String string) {
        return Jsoup.parseBodyFragment((String)string).text();
    }

    private static String getSanitized(String raw) {
        if (raw.isEmpty()) {
            return raw;
        }
        StringBuilder sb = new StringBuilder(raw.length());
        boolean crFlag = false;
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                if (c == '\r') {
                    if (crFlag) {
                        sb.append('\r').append('\n');
                    }
                    crFlag = true;
                    continue;
                }
                if (c == '\n') {
                    sb.append('\r').append('\n');
                    crFlag = false;
                    continue;
                }
                if (!crFlag) continue;
                sb.append('\r').append('\n');
                crFlag = false;
                continue;
            }
            if (crFlag) {
                sb.append('\r').append('\n');
            }
            crFlag = false;
            sb.append(c);
        }
        if (crFlag) {
            sb.append('\r').append('\n');
        }
        return sb.toString();
    }

    private void processPacket(Packet packet) throws IOException {
        block88: {
            logger.finer("Received packet " + packet.command + " " + packet.params);
            logger.finest("Recieved packet body: " + packet.body);
            block16 : switch (packet.command) {
                case "GET": {
                    String mainNode;
                    Document doc;
                    if (!packet.params.equals("MSGR")) break;
                    try {
                        doc = this.getDocument(packet.body);
                    }
                    catch (ParseException e) {
                        logger.log(Level.FINE, "Error while parsing GET MSGR message", e);
                        break;
                    }
                    switch (mainNode = doc.getFirstChild().getNodeName()) {
                        case "recentconversations-response": {
                            NodeList conversationNodes = doc.getElementsByTagName("conversation");
                            ArrayList<String> threadIds = new ArrayList<String>();
                            block65: for (int i = 0; i < conversationNodes.getLength(); ++i) {
                                Node conversation = conversationNodes.item(i);
                                String id = null;
                                boolean isThread = false;
                                NodeList conversationChildren = conversation.getChildNodes();
                                for (int j = 0; j < conversationChildren.getLength(); ++j) {
                                    Node child = conversationChildren.item(j);
                                    if (child.getNodeName().equals("id")) {
                                        id = child.getTextContent();
                                        continue;
                                    }
                                    if (child.getNodeName().equals("thread")) {
                                        isThread = true;
                                        NodeList threadNodes = child.getChildNodes();
                                        for (int k = 0; k < threadNodes.getLength(); ++k) {
                                            Node threadNode = threadNodes.item(k);
                                            if (threadNode.getNodeName().equals("lastleaveat")) continue block65;
                                        }
                                        continue;
                                    }
                                    if (child.getNodeName().equals("messages") && !child.hasChildNodes()) continue block65;
                                }
                                if (id == null || !isThread) continue;
                                Group group = (Group)this.parseEntity(id);
                                threadIds.add(group.getId());
                            }
                            if (!threadIds.isEmpty()) {
                                logger.finest("Fetching threads information");
                                StringBuilder sb = new StringBuilder("<threads>");
                                for (String threadId : threadIds) {
                                    if (sb.length() > 30000) {
                                        String body = sb.append("</threads>").toString();
                                        this.sendPacket("GET", "MSGR\\THREADS", body);
                                        sb.delete(0, sb.length());
                                        sb.append("<threads>");
                                    }
                                    sb.append("<thread><id>19:").append(threadId).append("@thread.skype</id></thread>");
                                }
                                String body = sb.append("</threads>").toString();
                                this.sendPacket("GET", "MSGR\\THREADS", body);
                                this.sendPacket("PNG", "CON", "");
                                break;
                            }
                            logger.finer("No threads received in recentconversations-response");
                            logger.fine("Connected! Stopped blocking.");
                            this.connectLatch.countDown();
                            break;
                        }
                        case "threads-response": {
                            NodeList threadNodes = doc.getElementsByTagName("thread");
                            for (int i = 0; i < threadNodes.getLength(); ++i) {
                                this.updateThread(threadNodes.item(i));
                            }
                            break block16;
                        }
                    }
                    break;
                }
                case "SDG": {
                    FormattedMessage formatted;
                    if (packet.body.isEmpty()) break;
                    try {
                        formatted = FormattedMessage.parseMessage(packet.body);
                    }
                    catch (IllegalArgumentException e) {
                        logger.log(Level.FINE, "Couldn't parse SDG formatted message", e);
                        break;
                    }
                    String messageType = formatted.headers.get("Message-Type");
                    if (messageType == null) break;
                    Object sender = this.parseEntity(formatted.sender);
                    Object receiver = this.parseEntity(formatted.receiver);
                    if (sender == null || receiver == null) break;
                    switch (messageType) {
                        case "Text": 
                        case "RichText": {
                            if (!(sender instanceof User)) {
                                logger.fine("Received " + messageType + " message sent from " + sender + " which isn't a user");
                                break block16;
                            }
                            if (receiver instanceof Group) {
                                this.skype.groupMessageReceived((Group)receiver, (User)sender, NotifConnector.getPlaintext(formatted.body));
                                break block16;
                            }
                            this.skype.userMessageReceived((User)sender, NotifConnector.getPlaintext(formatted.body));
                            break block16;
                        }
                        case "ThreadActivity/AddMember": {
                            List<String> usernames = this.getXMLFields(formatted.body, "target");
                            this.skype.usersAddedToGroup(usernames.stream().map(username -> this.parseEntity((String)username)).filter(Objects::nonNull).map(u -> (User)u).collect(Collectors.toList()), (Group)sender);
                            break block16;
                        }
                        case "ThreadActivity/DeleteMember": {
                            List<String> usernames = this.getXMLFields(formatted.body, "target");
                            this.skype.usersRemovedFromGroup(usernames.stream().map(username -> this.parseEntity((String)username)).filter(Objects::nonNull).map(u -> (User)u).collect(Collectors.toList()), (Group)sender);
                            break block16;
                        }
                        case "ThreadActivity/TopicUpdate": {
                            this.skype.groupTopicChanged((Group)sender, NotifConnector.getPlaintext(this.getXMLField(formatted.body, "value")));
                            break block16;
                        }
                        case "ThreadActivity/RoleUpdate": {
                            Document doc = this.getDocument(formatted.body);
                            NodeList targetNodes = doc.getElementsByTagName("target");
                            ArrayList<Pair<User, Role>> roles = new ArrayList<Pair<User, Role>>(targetNodes.getLength());
                            block70: for (int i = 0; i < targetNodes.getLength(); ++i) {
                                Node targetNode = targetNodes.item(i);
                                User user = null;
                                Role role = null;
                                for (int j = 0; j < targetNode.getChildNodes().getLength(); ++j) {
                                    Node targetPropertyNode = targetNode.getChildNodes().item(j);
                                    if (targetPropertyNode.getNodeName().equals("id")) {
                                        Object parseUser = this.parseEntity(targetPropertyNode.getTextContent());
                                        if (parseUser == null) continue block70;
                                        user = (User)parseUser;
                                        this.skype.updateUser(user);
                                        continue;
                                    }
                                    if (!targetPropertyNode.getNodeName().equals("role")) continue;
                                    role = Role.getRole(targetPropertyNode.getTextContent());
                                }
                                if (user == null || role == null) continue;
                                roles.add(new Pair<Object, Object>(user, role));
                            }
                            this.skype.usersRolesChanged((Group)sender, roles);
                            break block16;
                        }
                    }
                    break;
                }
                case "NFY": {
                    switch (packet.params) {
                        case "MSGR\\DEL": {
                            FormattedMessage formatted = FormattedMessage.parseMessage(packet.body);
                            Object parseUser = this.parseEntity(formatted.sender);
                            if (parseUser == null) break;
                            ((User)parseUser).setPresence(Presence.OFFLINE);
                            break;
                        }
                        case "MSGR\\PUT": {
                            FormattedMessage formatted = FormattedMessage.parseMessage(packet.body);
                            Object parseUser = this.parseEntity(formatted.sender);
                            if (parseUser == null) break;
                            User user = (User)parseUser;
                            String presenceString = this.getXMLField(formatted.body, "Status");
                            if (presenceString == null) {
                                presenceString = Presence.OFFLINE.getPresenceString();
                            }
                            user.setPresence(presenceString);
                            String moodString = this.getXMLField(formatted.body, "Mood");
                            if (moodString != null) {
                                user.setMood(NotifConnector.getPlaintext(moodString));
                                break;
                            }
                            break block88;
                        }
                        case "MSGR\\THREAD": {
                            Document document = this.getDocument(packet.body);
                            this.updateThread(document);
                            break;
                        }
                    }
                    break;
                }
                case "XFR": {
                    int port;
                    String newAddress = this.getXMLField(packet.body, "target");
                    if (newAddress == null) {
                        ParseException e = new ParseException("Received XFR message without target address");
                        logger.log(Level.SEVERE, "", e);
                        throw e;
                    }
                    Matcher matcherXFR = patternXFR.matcher(newAddress);
                    if (!matcherXFR.matches()) {
                        ParseException e = new ParseException("Received XFR message with target not matching pattern: address: " + newAddress);
                        logger.log(Level.SEVERE, "", e);
                        throw e;
                    }
                    String hostname = matcherXFR.group(1);
                    String portString = matcherXFR.group(2);
                    try {
                        port = Integer.parseUnsignedInt(portString);
                    }
                    catch (NumberFormatException e_) {
                        ParseException e = new ParseException("Couldn't parse port from XFR target: address: " + newAddress + " portString:" + portString, e_);
                        logger.log(Level.SEVERE, "", e);
                        throw e;
                    }
                    this.connectTo(hostname, port);
                    break;
                }
                case "CNT": {
                    String uic;
                    String nonce = this.getXMLField(packet.body, "nonce");
                    if (nonce == null) {
                        ParseException e = new ParseException("No nonce received in CNT message! Cannot compute UIC");
                        logger.log(Level.SEVERE, "", e);
                        throw e;
                    }
                    try {
                        uic = UicConnector.getUIC(this.username, this.password, nonce);
                    }
                    catch (GeneralSecurityException e) {
                        logger.log(Level.SEVERE, "Error when computing UIC token", e);
                        throw new RuntimeException(e);
                    }
                    this.sendPacket("ATH", "CON\\USER", "<user><uic>" + uic + "</uic><id>" + this.username + "</id></user>");
                    break;
                }
                case "ATH": {
                    this.sendPacket("BND", "CON\\MSGR", "<msgr><ver>2</ver><client><name>.</name><ver>.</ver><networks>skype</networks></client><epid>" + EPID + "</epid></msgr>");
                    break;
                }
                case "BND": {
                    String challenge = this.getXMLField(packet.body, "nonce");
                    if (challenge != null) {
                        logger.severe("Nonce field sent in BND message! Challenge needed but not included in this release: nonce: " + challenge);
                        this.skype.error(new IOException("Skype sent a nonce in the BND request, but it shouldn't do so anymore. If you see this error please open an issue on https://github.com/Delthas/JavaSkype/issues"));
                    }
                    String formattedPublicationBody = String.format("<user><s n=\"IM\"><Status>%s</Status></s><sep n=\"IM\" epid=\"{%s}\"><Capabilities>0:4194560</Capabilities></sep><s n=\"SKP\"><Mood/><Skypename>%s</Skypename></s><sep n=\"SKP\" epid=\"{%s}\"><Version>.</Version><Seamless>true</Seamless></sep></user>", this.skype.getSelf().getPresence().getPresenceString(), EPID, this.username, EPID);
                    String formattedPublicationMessage = FormattedMessage.format("8:" + this.username + ";epid={" + EPID + "}", "8:" + this.username, "Publication: 1.0", formattedPublicationBody, "Uri: /user", "Content-Type: application/user+xml");
                    this.sendPacket("PUT", "MSGR\\PRESENCE", formattedPublicationMessage);
                    this.sendPacket("PUT", "MSGR\\SUBSCRIPTIONS", "<subscribe><presence><buddies><all /></buddies></presence><messaging><im /><conversations /></messaging></subscribe>");
                    StringBuilder contactsStringBuilder = new StringBuilder("<ml l=\"1\"><skp>");
                    if (!this.skype.getContacts().isEmpty()) {
                        for (User contact : this.skype.getContacts()) {
                            if (contactsStringBuilder.length() > 30000) {
                                contactsStringBuilder.append("</skp></ml>");
                                String contactsString = contactsStringBuilder.toString();
                                this.sendPacket("PUT", "MSGR\\CONTACTS", contactsString);
                                contactsStringBuilder.delete(0, contactsStringBuilder.length());
                                contactsStringBuilder.append("<ml l=\"1\"><skp>");
                            }
                            contactsStringBuilder.append("<c n=\"");
                            contactsStringBuilder.append(contact.getUsername());
                            contactsStringBuilder.append("\" t=\"8\"><s l=\"3\" n=\"IM\"/><s l=\"3\" n=\"SKP\"/></c>");
                        }
                        contactsStringBuilder.append("</skp></ml>");
                        String contactsString = contactsStringBuilder.toString();
                        this.sendPacket("PUT", "MSGR\\CONTACTS", contactsString);
                    }
                    this.sendPacket("GET", "MSGR\\RECENTCONVERSATIONS", "<recentconversations><start>0</start><pagesize>100</pagesize></recentconversations>");
                    break;
                }
                case "OUT": {
                    logger.warning("Disconnected from Skype: " + packet.body);
                    this.skype.error(new IOException("Disconnected: " + packet.body));
                    break;
                }
                case "PUT": {
                    break;
                }
                case "PNG": {
                    if (this.connectLatch.getCount() <= 0L) break;
                    logger.finest("Received first pong");
                    logger.fine("Connected! Stopped blocking.");
                    this.connectLatch.countDown();
                    break;
                }
                default: {
                    System.out.println("Received unknown message: " + packet);
                }
            }
        }
    }

    private Packet readPacket() throws IOException {
        int n;
        int payloadSize;
        StringBuilder firstLineBuilder = new StringBuilder();
        boolean crFlag = false;
        while (true) {
            int read;
            if ((read = this.inputStream.read()) == -1) {
                logger.warning("EOF reached in stream");
                return null;
            }
            char character = (char)(read & 0xFF);
            if (crFlag) {
                if (character == '\n') break;
                ParseException e = new ParseException("Received \\r without \\n in: " + firstLineBuilder);
                logger.log(Level.SEVERE, "", e);
                throw e;
            }
            if (character == '\n') break;
            if (character == '\r') {
                crFlag = true;
                continue;
            }
            firstLineBuilder.append(character);
        }
        String firstLine = firstLineBuilder.toString();
        Matcher matcherFirstLine = patternFirstLine.matcher(firstLine);
        if (!matcherFirstLine.matches()) {
            ParseException e = new ParseException("Error matching message first line: " + firstLine);
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
        String command = matcherFirstLine.group(1);
        String parameters = matcherFirstLine.group(2);
        String payloadSizeString = matcherFirstLine.group(3);
        try {
            payloadSize = Integer.parseInt(payloadSizeString);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e);
        }
        byte[] payloadRaw = new byte[payloadSize];
        for (int bytesRead = 0; bytesRead != payloadSize; bytesRead += n) {
            n = this.inputStream.read(payloadRaw, bytesRead, payloadSize - bytesRead);
            if (n != -1) continue;
            ParseException e = new ParseException("EOF when reading message payload (size: " + payloadSize + ")");
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
        String payload = new String(payloadRaw, StandardCharsets.UTF_8);
        if (command.matches("\\d+")) {
            ParseException e = new ParseException("Error message received:\n" + firstLine + "\n" + payload);
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
        Matcher matcherHeaders = patternHeaders.matcher(payload);
        if (!matcherHeaders.find()) {
            ParseException e = new ParseException("Couldn't find headers in payload: " + payload);
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
        String newRegistration = matcherHeaders.group(1);
        if (newRegistration != null) {
            logger.finest("Set registration: " + newRegistration);
            this.registration = newRegistration;
        }
        String body = payload.substring(matcherHeaders.end());
        return new Packet(command, parameters, body);
    }

    public void connect() throws IOException, InterruptedException {
        logger.finer("Starting notification connector");
        this.disconnectRequested = false;
        this.lastMessageSentTime = System.nanoTime();
        this.connectTo(DEFAULT_SERVER_HOSTNAME, 443);
        new Thread(() -> {
            while (!this.disconnectRequested) {
                try {
                    Packet packet = this.readPacket();
                    if (packet == null) continue;
                    this.processPacket(packet);
                }
                catch (IOException e) {
                    if (this.disconnectRequested) {
                        return;
                    }
                    logger.log(Level.SEVERE, "Error while reading packet", e);
                    this.skype.error(e);
                    this.connectLatch.countDown();
                    break;
                }
            }
        }, "Skype-Receiver-Thread").start();
        this.pingThread = new Thread(() -> {
            while (!Thread.interrupted() && !this.disconnectRequested) {
                if (System.nanoTime() - this.lastMessageSentTime > 120000000000L) {
                    try {
                        this.sendPacket("PNG", "CON", "");
                        this.sendPacket("PUT", "MSGR\\ACTIVEENDPOINT", "<activeendpoint><timeout>135</timeout></activeendpoint>");
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Error while sending ping", e);
                        this.skype.error(e);
                        break;
                    }
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        }, "Skype-Ping-Thread");
        logger.finest("Ping interval: 120000ms");
        logger.finer("Waiting for connection");
        this.connectLatch.await();
        this.pingThread.start();
    }

    public void sendUserMessage(User user, String message) throws IOException {
        this.sendMessage("8:" + user.getUsername(), NotifConnector.getSanitized(message));
    }

    public void sendGroupMessage(Group group, String message) throws IOException {
        this.sendMessage("19:" + group.getId() + "@thread.skype", NotifConnector.getSanitized(message));
    }

    public void addUserToGroup(User user, Role role, Group group) throws IOException {
        String body = String.format("<thread><id>19:%s@thread.skype</id><members><member><mri>8:%s</mri><role>%s</role></member></members></thread>", group.getId(), user.getUsername(), role.getRoleString());
        this.sendPacket("PUT", "MSGR\\THREAD", body);
    }

    public void removeUserFromGroup(User user, Group group) throws IOException {
        String body = String.format("<thread><id>19:%s@thread.skype</id><members><member><mri>8:%s</mri></member></members></thread>", group.getId(), user.getUsername());
        this.sendPacket("DEL", "MSGR\\THREAD", body);
    }

    public void changeGroupTopic(Group group, String topic) throws IOException {
        String body = String.format("<thread><id>19:%s@thread.skype</id><properties><topic>%s</topic></properties></thread>", group.getId(), NotifConnector.getSanitized(topic));
        this.sendPacket("PUT", "MSGR\\THREAD", body);
    }

    public void changeUserRole(User user, Role role, Group group) throws IOException {
        String body = String.format("<thread><id>19:%s@thread.skype</id><members><member><mri>8:%s</mri><role>%s</role></member></members></thread>", group.getId(), user.getUsername(), role.getRoleString());
        this.sendPacket("PUT", "MSGR\\THREAD", body);
    }

    public void changePresence(Presence presence) throws IOException {
        String formattedPublicationBody = String.format("<user><s n=\"IM\"><Status>%s</Status></s></user>", presence.getPresenceString());
        String formattedPublicationMessage = FormattedMessage.format("8:" + this.username + ";epid={" + EPID + "}", "8:" + this.username, "Publication: 1.0", formattedPublicationBody, "Uri: /user", "Content-Type: application/user+xml");
        this.sendPacket("PUT", "MSGR\\PRESENCE", formattedPublicationMessage);
    }

    private void sendMessage(String entity, String message) throws IOException {
        String body = FormattedMessage.format("8:" + this.username + ";epid={" + EPID + "}", entity, "Messaging: 2.0", message, "Content-Type: application/user+xml", "Message-Type: RichText");
        this.sendPacket("SDG", "MSGR", body);
    }

    public synchronized void disconnect() {
        logger.finer("Stopping notification connector");
        try {
            this.sendPacket("OUT", "CON", "");
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error received while disconnecting", e);
        }
        this.disconnectRequested = true;
        this.pingThread.interrupt();
        this.connectLatch.countDown();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error while trying to close the socket", e);
            }
        }
    }

    private synchronized void sendPacket(String command, String parameters, String body) throws IOException {
        String headerString = this.registration != null ? "Registration: " + this.registration + "\r\n" : "";
        String messageString = String.format("%s %d %s %d\r\n%s\r\n%s", command, ++this.sequenceNumber, parameters, body.getBytes(StandardCharsets.UTF_8).length + 2 + headerString.length(), headerString, body);
        try {
            this.writer.write(messageString);
            this.writer.flush();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while trying to send message: " + messageString, e);
            throw e;
        }
        logger.finest("Sent packet: " + messageString);
        this.lastMessageSentTime = System.nanoTime();
    }

    private void connectTo(String hostname, int port) throws IOException {
        logger.finest("Connecting to hostname: " + hostname + " port: " + port);
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = SSLSocketFactory.getDefault().createSocket(hostname, port);
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        this.sequenceNumber = 0;
        this.sendPacket("CNT", "CON", "<connect><ver>2</ver><agent><os>.</os><osVer>.</osVer><proc>.</proc><lcid>en-us</lcid></agent></connect>");
    }

    private void updateThread(Node threadNode) {
        Group group = null;
        String topic = null;
        Node members = null;
        for (int i = 0; i < threadNode.getChildNodes().getLength(); ++i) {
            Node node = threadNode.getChildNodes().item(i);
            if (node.getNodeName().equals("id")) {
                group = (Group)this.parseEntity(node.getTextContent());
                continue;
            }
            if (node.getNodeName().equals("members")) {
                members = node;
                continue;
            }
            if (!node.getNodeName().equals("properties")) continue;
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node topicNode = node.getChildNodes().item(j);
                if (!topicNode.getNodeName().equals("topic")) continue;
                topic = topicNode.getTextContent();
            }
        }
        if (group == null || topic == null || members == null) {
            return;
        }
        ArrayList<Pair<User, Role>> users = new ArrayList<Pair<User, Role>>(members.getChildNodes().getLength());
        block2: for (int i = 0; i < members.getChildNodes().getLength(); ++i) {
            Node memberNode = members.getChildNodes().item(i);
            if (!memberNode.getNodeName().equals("member")) continue;
            User user = null;
            Role role = null;
            for (int j = 0; j < memberNode.getChildNodes().getLength(); ++j) {
                Node memberPropertyNode = memberNode.getChildNodes().item(j);
                if (memberPropertyNode.getNodeName().equals("mri")) {
                    Object parseUser = this.parseEntity(memberPropertyNode.getTextContent());
                    if (parseUser == null) continue block2;
                    user = (User)parseUser;
                    this.skype.updateUser(user);
                    continue;
                }
                if (!memberPropertyNode.getNodeName().equals("role")) continue;
                role = Role.getRole(memberPropertyNode.getTextContent());
            }
            if (user == null || role == null) continue;
            users.add(new Pair<Object, Object>(user, role));
        }
        group.setTopic(topic);
        group.setUsers(users);
    }

    private Object parseEntity(String rawEntity) {
        int senderEnd;
        logger.finest("Parsing entity " + rawEntity);
        int senderBegin = rawEntity.indexOf(58);
        int network = Integer.parseInt(rawEntity.substring(0, senderBegin));
        int end0 = rawEntity.indexOf(64);
        int end1 = rawEntity.indexOf(59);
        if (end0 == -1) {
            end0 = Integer.MAX_VALUE;
        }
        if (end1 == -1) {
            end1 = Integer.MAX_VALUE;
        }
        String name = (senderEnd = Math.min(end0, end1)) == Integer.MAX_VALUE ? rawEntity.substring(senderBegin + 1) : rawEntity.substring(senderBegin + 1, senderEnd);
        if (network == 8) {
            return this.skype.getUser(name);
        }
        if (network == 19) {
            return this.skype.getGroup(name);
        }
        if (network == 4) {
            return null;
        }
        logger.warning("Error while parsing entity " + rawEntity + ": unknown network:" + network);
        throw new IllegalArgumentException();
    }

    private Document getDocument(String XML) throws ParseException {
        try {
            return this.documentBuilder.parse(new InputSource(new StringReader(XML)));
        }
        catch (IOException | SAXException e) {
            logger.log(Level.WARNING, "Error while parsing XML String: " + XML, e);
            throw new ParseException(e);
        }
    }

    private List<String> getXMLFields(String XML, String fieldName) throws ParseException {
        NodeList nodes = this.getDocument(XML).getElementsByTagName(fieldName);
        ArrayList<String> fields = new ArrayList<String>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            fields.add(nodes.item(i).getTextContent());
        }
        return fields;
    }

    private String getXMLField(String XML, String fieldName) throws ParseException {
        List<String> fields = this.getXMLFields(XML, fieldName);
        if (fields.size() > 1) {
            throw new ParseException();
        }
        if (fields.size() == 0) {
            return null;
        }
        return fields.get(0);
    }

    private static class Packet {
        public final String command;
        public final String params;
        public final String body;

        public Packet(String command, String params, String body) {
            this.command = command;
            this.params = params;
            this.body = body;
        }

        public String toString() {
            return String.format("Command: %s Params: %s Body: %s", this.command, this.params, this.body);
        }
    }
}

