/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.skype;

import fr.delthas.skype.Pair;
import fr.delthas.skype.Role;
import fr.delthas.skype.Skype;
import fr.delthas.skype.User;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class Group {
    private final Skype skype;
    private final String id;
    private List<Pair<User, Role>> users;
    private String topic;

    Group(Skype skype, String id) {
        this.skype = skype;
        this.id = id;
        this.users = Collections.emptyList();
        this.topic = "";
    }

    public void sendMessage(String message) {
        this.skype.sendGroupMessage(this, message);
    }

    public String getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    void setTopic(String topic) {
        this.topic = topic;
    }

    public void changeTopic(String topic) {
        this.skype.changeGroupTopic(this, topic);
    }

    public List<Pair<User, Role>> getUsersWithRoles() {
        return this.users;
    }

    public List<User> getUsers() {
        return this.users.stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    void setUsers(List<Pair<User, Role>> users) {
        this.users = users;
    }

    public boolean addUser(User user, Role role) {
        if (!this.isSelfAdmin() && role == Role.ADMIN) {
            return false;
        }
        for (Pair<User, Role> pair : this.users) {
            if (!user.equals(pair.getFirst())) continue;
            return false;
        }
        this.users.add(new Pair<User, Role>(user, role));
        this.skype.addUserToGroup(user, role, this);
        return true;
    }

    public boolean removeUser(User user) {
        if (!this.isSelfAdmin()) {
            return false;
        }
        Iterator<Pair<User, Role>> it = this.users.iterator();
        while (it.hasNext()) {
            Pair<User, Role> pair = it.next();
            if (!user.equals(pair.getFirst())) continue;
            it.remove();
            this.skype.removeUserFromGroup(user, this);
            return true;
        }
        return true;
    }

    public boolean changeUserRole(User user, Role role) {
        if (!this.isSelfAdmin()) {
            return false;
        }
        ListIterator<Pair<User, Role>> it = this.users.listIterator();
        while (it.hasNext()) {
            Pair<User, Role> pair = it.next();
            if (!user.equals(pair.getFirst())) continue;
            if (role == pair.getSecond()) {
                return false;
            }
            it.remove();
            it.add(new Pair<User, Role>(user, role));
            this.skype.changeUserRole(user, role, this);
            return true;
        }
        return false;
    }

    public boolean isSelfAdmin() {
        User self = this.skype.getSelf();
        for (Pair<User, Role> pair : this.users) {
            if (!pair.getFirst().equals(self)) continue;
            return pair.getSecond() == Role.ADMIN;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Group: " + this.getId();
    }
}

