/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.skype;

import fr.delthas.skype.Skype;
import fr.delthas.skype.User;

public class ContactRequest {
    private Skype skype;
    private String username;
    private String greeting;
    private boolean processed = false;

    ContactRequest(Skype skype, String username, String greeting) {
        this.skype = skype;
        this.username = username;
        this.greeting = greeting;
    }

    public void accept() {
        if (this.processed) {
            return;
        }
        this.skype.acceptContactRequest(this);
        this.processed = true;
    }

    public void decline() {
        if (this.processed) {
            return;
        }
        this.skype.declineContactRequest(this);
        this.processed = true;
    }

    public User getUser() {
        return this.skype.getUser(this.username);
    }

    public String getGreeting() {
        return this.greeting;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactRequest)) {
            return false;
        }
        ContactRequest other = (ContactRequest)obj;
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "Contact Request: User: " + this.username + " Greeting: " + this.greeting;
    }
}

