/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class IteratorIdioms
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    boolean sawNoSuchElement;

    public IteratorIdioms(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals("next") && this.getMethodSig().equals("()Ljava/lang/Object;")) {
            this.sawNoSuchElement = false;
            super.visit(obj);
            if (!this.sawNoSuchElement) {
                this.bugReporter.reportBug(new BugInstance("IT_NO_SUCH_ELEMENT", 2).addClassAndMethod((PreorderVisitor)this));
            }
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 187 && this.getClassConstantOperand().equals("java/util/NoSuchElementException")) {
            this.sawNoSuchElement = true;
        } else if ((seen == 183 || seen == 182 || seen == 185) && this.getNameConstantOperand().indexOf("next") >= 0) {
            this.sawNoSuchElement = true;
        }
    }
}

