/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class FindRunInvocations
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    private boolean alreadySawStart;

    public FindRunInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private boolean isThread(String clazz) {
        try {
            return Hierarchy.isSubtype((String)clazz, (String)"java.lang.Thread");
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return false;
        }
    }

    public void visit(Code obj) {
        this.alreadySawStart = false;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.alreadySawStart) {
            return;
        }
        if ((seen == 182 || seen == 185) && this.getSigConstantOperand().equals("()V") && this.isThread(this.getDottedClassConstantOperand())) {
            if (this.getNameConstantOperand().equals("start")) {
                this.alreadySawStart = true;
            } else if (this.getNameConstantOperand().equals("run")) {
                this.bugReporter.reportBug(new BugInstance("RU_INVOKE_RUN", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
            }
        }
    }
}

