/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.TypeDataflow;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindJSR166LockMonitorenter
implements Detector {
    private BugReporter bugReporter;
    private static final ObjectType LOCK_TYPE = new ObjectType("java.util.concurrent.locks.Lock");

    public FindJSR166LockMonitorenter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass jclass = classContext.getJavaClass();
        Method[] methodList = jclass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (method.getCode() == null) continue;
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        try {
            BitSet bytecodeSet = classContext.getBytecodeSet(method);
            if (!bytecodeSet.get(194)) {
                return;
            }
            CFG cfg = classContext.getCFG(method);
            TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
            Iterator i = cfg.blockIterator();
            while (i.hasNext()) {
                BasicBlock basicBlock = (BasicBlock)i.next();
                BasicBlock.InstructionIterator j = basicBlock.instructionIterator();
                while (j.hasNext()) {
                    boolean isSubtype;
                    InstructionHandle handle = (InstructionHandle)j.next();
                    Instruction ins = handle.getInstruction();
                    if (ins.getOpcode() != 194) continue;
                    Type type = (Type)typeDataflow.getFactAtLocation(new Location(handle, basicBlock)).getInstance(ins, cpg);
                    if (!(type instanceof ReferenceType)) {
                        return;
                    }
                    try {
                        isSubtype = Hierarchy.isSubtype((ReferenceType)((ReferenceType)type), (ReferenceType)LOCK_TYPE);
                    }
                    catch (ClassNotFoundException e) {
                        this.bugReporter.reportMissingClass(e);
                        return;
                    }
                    if (!isSubtype) continue;
                    MethodGen mg = classContext.getMethodGen(method);
                    String sourceFile = classContext.getJavaClass().getSourceFileName();
                    this.bugReporter.reportBug(new BugInstance("JLM_JSR166_LOCK_MONITORENTER", 2).addClassAndMethod(mg, sourceFile).addSourceLine(mg, sourceFile, handle));
                }
            }
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("FindJSR166LockMonitorenter: caught exception " + e.toString(), (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("FindJSR166LockMonitorenter: caught exception " + e.toString(), (Throwable)e);
        }
    }

    public void report() {
    }
}

