/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindHEmismatch
extends BytecodeScanningDetector
implements Constants2 {
    boolean hasFields = false;
    boolean hasHashCode = false;
    boolean hasEqualsObject = false;
    boolean hasCompareToObject = false;
    boolean hasEqualsSelf = false;
    boolean hasCompareToSelf = false;
    boolean extendsObject = false;
    private BugReporter bugReporter;

    public FindHEmismatch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitAfter(JavaClass obj) {
        try {
            if (!obj.isClass()) {
                return;
            }
            if (this.getDottedClassName().equals("java.lang.Object")) {
                return;
            }
            int accessFlags = obj.getAccessFlags();
            if ((accessFlags & 0x200) != 0) {
                return;
            }
            String whereEqual = this.getDottedClassName();
            if (!this.hasEqualsObject) {
                whereEqual = Lookup.findSuperImplementor((JavaClass)obj, (String)"equals", (String)"(Ljava/lang/Object;)Z", (BugReporter)this.bugReporter).getClassName();
            }
            boolean usesDefaultEquals = whereEqual.equals("java.lang.Object");
            String whereHashCode = this.getDottedClassName();
            if (!this.hasHashCode) {
                whereHashCode = Lookup.findSuperImplementor((JavaClass)obj, (String)"hashCode", (String)"()I", (BugReporter)this.bugReporter).getClassName();
            }
            boolean usesDefaultHashCode = whereHashCode.equals("java.lang.Object");
            if (!this.hasEqualsObject && this.hasEqualsSelf) {
                if (usesDefaultEquals) {
                    this.bugReporter.reportBug(new BugInstance("EQ_SELF_USE_OBJECT", 1).addClass(this.getDottedClassName()));
                } else {
                    this.bugReporter.reportBug(new BugInstance("EQ_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()));
                }
            }
            if (!this.hasCompareToObject && this.hasCompareToSelf && !this.extendsObject) {
                this.bugReporter.reportBug(new BugInstance("CO_SELF_NO_OBJECT", 2).addClass(this.getDottedClassName()));
            }
            if (this.hasHashCode && !this.hasEqualsObject && !this.hasEqualsSelf) {
                if (usesDefaultEquals) {
                    this.bugReporter.reportBug(new BugInstance("HE_HASHCODE_USE_OBJECT_EQUALS", 3).addClass(this.getDottedClassName()));
                } else {
                    this.bugReporter.reportBug(new BugInstance("HE_HASHCODE_NO_EQUALS", 3).addClass(this.getDottedClassName()));
                }
            }
            if (!this.hasHashCode && (this.hasEqualsObject || this.hasEqualsSelf)) {
                if (usesDefaultHashCode) {
                    this.bugReporter.reportBug(new BugInstance("HE_EQUALS_USE_HASHCODE", 1).addClass(this.getDottedClassName()));
                } else {
                    this.bugReporter.reportBug(new BugInstance("HE_EQUALS_NO_HASHCODE", this.hasFields ? 2 : 3).addClass(this.getDottedClassName()));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void visit(JavaClass obj) {
        this.extendsObject = this.getDottedSuperclassName().equals("java.lang.Object");
        this.hasFields = false;
        this.hasHashCode = false;
        this.hasCompareToObject = false;
        this.hasCompareToSelf = false;
        this.hasEqualsObject = false;
        this.hasEqualsSelf = false;
        int accessFlags = obj.getAccessFlags();
    }

    public void visit(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        this.hasFields = true;
    }

    public void visit(Method obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0) {
            return;
        }
        String name = obj.getName();
        String sig = obj.getSignature();
        boolean sigIsObject = sig.equals("(Ljava/lang/Object;)Z");
        if (name.equals("hashCode") && sig.equals("()I")) {
            this.hasHashCode = true;
        } else if (name.equals("equals")) {
            if (sigIsObject) {
                this.hasEqualsObject = true;
            } else if (sig.equals("(L" + this.getClassName() + ";)Z")) {
                this.hasEqualsSelf = true;
            }
        } else if (name.equals("compareTo")) {
            if (sig.equals("(Ljava/lang/Object;)I")) {
                this.hasCompareToObject = true;
            } else if (sig.equals("(L" + this.getClassName() + ";)I")) {
                this.hasCompareToSelf = true;
            }
        }
    }
}

