/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.markdown.entities;

import android.graphics.Color;
import eu.codlab.markdown.entities.MarkDownEntity;
import java.util.HashMap;

public class ColorEntity
extends MarkDownEntity {
    private static final int DEFAULT_COLOR = -1;
    private static final int DEFAULT_COLOR_WHITE = 0;
    private static final HashMap<String, Integer> _color_map = new HashMap();
    private int _color;
    private int _r;
    private int _g;
    private int _b;
    private int _background_color;
    private int _background_r;
    private int _background_g;
    private int _background_b;

    private ColorEntity() {
        _color_map.put("black", -16777216);
        _color_map.put("dkgray", -12303292);
        _color_map.put("gray", -7829368);
        _color_map.put("ltgray", -3355444);
        _color_map.put("white", -1);
        _color_map.put("red", -65536);
        _color_map.put("green", -16711936);
        _color_map.put("blue", -16776961);
        _color_map.put("yellow", -256);
        _color_map.put("cyan", -16711681);
        _color_map.put("magenta", -65281);
        _color_map.put("transparent", 0);
        this._background_color = 0;
        this._background_r = -1;
        this._background_g = -1;
        this._background_b = -1;
    }

    public ColorEntity(String xml) {
        this();
        this.setXMLTextColor(xml);
    }

    public ColorEntity(String xml, String background_xml) {
        this();
        this.setXMLTextColor(xml);
        this.setXMLBackgroundColor(background_xml);
    }

    public ColorEntity(String r, String g, String b, String br, String bg, String bb) {
        this(Integer.parseInt(r.trim()), Integer.parseInt(g.trim()), Integer.parseInt(b.trim()), Integer.parseInt(br.trim()), Integer.parseInt(bg.trim()), Integer.parseInt(bb.trim()));
    }

    public ColorEntity(String r, String g, String b) {
        this(Integer.parseInt(r.trim()), Integer.parseInt(g.trim()), Integer.parseInt(b.trim()));
    }

    public ColorEntity(int r, int g, int b, int br, int bg, int bb) {
        this();
        this._r = r % 256;
        this._g = g % 256;
        this._b = b % 256;
        this._color = -1;
        this._background_r = br % 256;
        this._background_g = bg % 256;
        this._background_b = bb % 256;
        this._background_color = 0;
    }

    public ColorEntity(int r, int g, int b) {
        this();
        this._r = r % 256;
        this._g = g % 256;
        this._b = b % 256;
        this._color = -1;
    }

    private void setXMLBackgroundColor(String xml) {
        try {
            xml = xml.toLowerCase();
            Integer color = _color_map.get(xml.trim());
            this._background_color = color != null ? color : (xml.indexOf("#") < 0 ? Color.parseColor((String)("#" + xml.trim())) : Color.parseColor((String)xml.trim()));
        }
        catch (Exception e) {
            this._background_color = -16777216;
        }
        this._background_r = -1;
        this._background_g = -1;
        this._background_b = -1;
    }

    private void setXMLTextColor(String xml) {
        try {
            xml = xml.toLowerCase();
            Integer color = _color_map.get(xml.trim());
            this._color = color != null ? color : (xml.indexOf("#") < 0 ? Color.parseColor((String)("#" + xml.trim())) : Color.parseColor((String)xml.trim()));
        }
        catch (Exception e) {
            this._color = -16777216;
        }
        this._r = -1;
        this._g = -1;
        this._b = -1;
    }

    public int getR() {
        return this._r;
    }

    public int getG() {
        return this._g;
    }

    public int getB() {
        return this._b;
    }

    public int getBackgroundR() {
        return this._background_r;
    }

    public int getBackgroundG() {
        return this._background_g;
    }

    public int getBackgroundB() {
        return this._background_b;
    }

    public int getColorInteger() {
        if (this._color != -1) {
            return this._color;
        }
        return Color.rgb((int)this.getR(), (int)this.getG(), (int)this.getB());
    }

    public boolean isDefaultColor() {
        return this.getR() == -1 && this.getG() == -1 && this.getB() == -1 && this._color == -1;
    }

    public static ColorEntity createDefaultColor() {
        return new ColorEntity(-1, -1, -1);
    }

    public boolean hasBackgroundColor() {
        return this.getBackgroundR() != -1 && this.getBackgroundG() != -1 && this.getBackgroundB() != -1 || this._background_color != 0;
    }

    public int getBackgroundColorInteger() {
        if (this._background_color != 0) {
            return this._background_color;
        }
        return Color.rgb((int)this.getBackgroundR(), (int)this.getBackgroundG(), (int)this.getBackgroundB());
    }
}

