/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.recyclercolumnadaptable.view;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import eu.codlab.recyclercolumnadaptable.R;
import eu.codlab.recyclercolumnadaptable.RecyclerColumnsWithContentView;
import eu.codlab.recyclercolumnadaptable.adapter.AbstractColumnItemHolder;
import eu.codlab.recyclercolumnadaptable.adapter.ColumnItemHolder;
import eu.codlab.recyclercolumnadaptable.adapter.EmptyItemHolder;
import eu.codlab.recyclercolumnadaptable.adapter.HeaderItemHolder;
import eu.codlab.recyclercolumnadaptable.inflater.AbstractItemInflater;
import eu.codlab.recyclercolumnadaptable.item.AbstractItem;
import eu.codlab.recyclercolumnadaptable.item.EmptyItem;
import eu.codlab.recyclercolumnadaptable.item.HeaderItem;
import java.util.ArrayList;
import java.util.List;

public class MainArrayAdapter
extends RecyclerView.Adapter<AbstractColumnItemHolder> {
    private static final int ITEM_EMPTY = 0;
    private static final int ITEM_CONTENT = 1;
    private static final int ITEM_HEADER = 2;
    private AbstractItemInflater _provider;
    private List<AbstractItem> _content;
    private boolean _is_expanded;
    private int _column_count;
    private int _column_left;

    public static final MainArrayAdapter instantiate(AbstractItemInflater provider, RecyclerColumnsWithContentView grid) {
        return new MainArrayAdapter(provider, grid.getColumns(), grid.getColumnsExpandedVisible());
    }

    public MainArrayAdapter(AbstractItemInflater provider, int column_count, int column_left) {
        this._provider = provider;
        this._is_expanded = false;
        this._column_count = column_count;
        this._column_left = column_left;
        this._content = new ArrayList<AbstractItem>();
        if (this._provider.hasHeader()) {
            this._content.add(new HeaderItem());
        }
        for (int i = 0; i < this._provider.getItemCount(); ++i) {
            this._content.add(this._provider.getContentItemAt(i).updatePosition(i));
        }
        this.expand();
    }

    public AbstractColumnItemHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new HeaderItemHolder(this._provider.getHeader(parent), this.isExpanded());
        }
        if (viewType == 1) {
            return this._provider.onCreateViewHolder(parent);
        }
        return new EmptyItemHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.view_empty, parent, false));
    }

    public int getItemViewType(int position) {
        if (this._content.get(position) instanceof HeaderItem) {
            return 2;
        }
        if (this._content.get(position) instanceof EmptyItem) {
            return 0;
        }
        return 1;
    }

    public void onBindViewHolder(AbstractColumnItemHolder holder, int position) {
        if (holder instanceof HeaderItemHolder) {
            HeaderItemHolder header = (HeaderItemHolder)holder;
        }
        if (holder instanceof ColumnItemHolder) {
            ColumnItemHolder current_holder = (ColumnItemHolder)holder;
            holder.onBindViewHolder(this._content.get(position));
            this._provider.onBindViewHolder((ColumnItemHolder)holder);
        }
    }

    public int getItemCount() {
        return this._content.size();
    }

    public AbstractItem getItemAt(int i) {
        return this._content.get(i);
    }

    public void expand() {
        if (!this._is_expanded) {
            this.unsetEmptyContent();
            this._is_expanded = true;
        }
    }

    public void collapse() {
        if (this._is_expanded) {
            this.setEmptyContent();
            this._is_expanded = false;
        }
    }

    public boolean isExpanded() {
        return this._is_expanded;
    }

    public int transformInArrayToPositionInRecycler(int position) {
        if (!this.isExpanded()) {
            int modulo = position % this._column_left;
            int number_row = position / this._column_left;
            int row_index = number_row * this._column_count;
            int index_row_column = row_index + modulo;
            return index_row_column;
        }
        return position;
    }

    private void setEmptyContent() {
        int column_at_right = this._column_count - this._column_left;
        boolean has_fetched_item = true;
        ArrayList<Changed> changed = new ArrayList<Changed>();
        ArrayList<AbstractItem> items = new ArrayList<AbstractItem>();
        int original_index = 0;
        if (this._provider.hasHeader() && this._content.size() > 0) {
            items.add(this._content.get(0));
            ++original_index;
        }
        while (has_fetched_item) {
            int i;
            has_fetched_item = false;
            int count = 0;
            for (i = original_index; count < this._column_left && i < this._content.size(); ++count, ++i) {
                items.add(this._content.get(i));
                has_fetched_item = true;
                ++original_index;
            }
            if (!has_fetched_item) continue;
            int index = items.size();
            for (i = 0; i < column_at_right; ++i) {
                items.add(new EmptyItem());
            }
            changed.add(new Changed(index, column_at_right));
        }
        this._content = items;
        for (Changed change : changed) {
            this.notifyItemRangeInserted(change.start, change.count);
        }
        if (this._provider.hasHeader()) {
            this._content.remove(0);
            this.notifyItemRemoved(0);
        }
    }

    private void unsetEmptyContent() {
        ArrayList<Changed> changed = new ArrayList<Changed>();
        int index_cursor = 0;
        Changed change = null;
        while (index_cursor < this._content.size()) {
            AbstractItem tmp = this._content.get(index_cursor);
            if (tmp instanceof EmptyItem) {
                if (change == null) {
                    change = new Changed(index_cursor, 0);
                }
                this._content.remove(index_cursor);
                ++change.count;
                continue;
            }
            if (change != null) {
                changed.add(change);
                change = null;
            }
            ++index_cursor;
        }
        if (change != null) {
            changed.add(change);
        }
        for (Changed remove : changed) {
            this.notifyItemRangeRemoved(remove.start, remove.count);
        }
        if (this._provider.hasHeader() && (this._content.size() == 0 || !(this._content.get(0) instanceof HeaderItem))) {
            this._content.add(0, new HeaderItem());
            this.notifyItemInserted(0);
        }
    }

    private class Changed {
        public int start;
        public int count;

        public Changed(int start, int count) {
            this.start = start;
            this.count = count;
        }
    }
}

