/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.recyclercolumnadaptable;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import eu.codlab.recyclercolumnadaptable.IRecyclerColumnsListener;
import eu.codlab.recyclercolumnadaptable.R;
import eu.codlab.recyclercolumnadaptable.inflater.AbstractItemInflater;
import eu.codlab.recyclercolumnadaptable.item.AbstractItem;
import eu.codlab.recyclercolumnadaptable.item.HeaderItem;
import eu.codlab.recyclercolumnadaptable.manager.GridLayoutSmoothManager;
import eu.codlab.recyclercolumnadaptable.view.MainArrayAdapter;
import java.util.ArrayList;
import java.util.List;
import jp.wasabeef.recyclerview.animators.LandingAnimator;

public class RecyclerColumnsWithContentView
extends FrameLayout {
    private static final long DELAY_INVALIDATE_DECORATIONS = 300L;
    private static final long DELAY_SET_SCROLL_POSITION = 200L;
    private static final int MINIMUM_COLUMNS_COUNT = 3;
    private static final int MINIMUM_COLUMNS_WHILE_BEING_EXPANDED_COUNT = 1;
    private int _columns_left = 0;
    private int _columns = 0;
    private RecyclerView _recycler;
    private ViewGroup _left;
    private ViewGroup _content;
    private IRecyclerColumnsListener _listener;
    private List<RecyclerView.ItemDecoration> _tmp_decorations = new ArrayList<RecyclerView.ItemDecoration>();
    private LinearLayout _footer_parent;
    private LinearLayout _footer;
    private LinearLayout _footer_content;
    private Boolean temporary_to_store_is_showing_content = null;

    private void init(AttributeSet attrs) {
        TypedArray array;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_recycler_columns, (ViewGroup)this, true);
        this._recycler = (RecyclerView)this.findViewById(R.id.recycler);
        this._left = (ViewGroup)this.findViewById(R.id.left);
        this._content = (ViewGroup)this.findViewById(R.id.content);
        this._footer = (LinearLayout)this.findViewById(R.id.footer);
        this._footer_parent = (LinearLayout)this.findViewById(R.id.footer_parent);
        this._footer_content = (LinearLayout)this.findViewById(R.id.content_footer);
        if (attrs != null && (array = this.getContext().obtainStyledAttributes(attrs, R.styleable.RecyclerColumnsWithContentView)) != null) {
            this._columns = array.getInteger(R.styleable.RecyclerColumnsWithContentView_columns, 3);
            this._columns_left = array.getInteger(R.styleable.RecyclerColumnsWithContentView_columnsVisibleExpanded, 1);
            this._columns = Math.max(this._columns, 3);
            this.setColumnsExpandedVisible(Math.max(this._columns_left, 1));
        }
        GridLayoutSmoothManager grid_manager = new GridLayoutSmoothManager(this.getContext(), this._columns);
        grid_manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                return position == 0 && RecyclerColumnsWithContentView.this.hasHeader() ? RecyclerColumnsWithContentView.this.getColumns() : 1;
            }
        });
        this._recycler.setLayoutManager((RecyclerView.LayoutManager)grid_manager);
        this._recycler.setItemAnimator((RecyclerView.ItemAnimator)new LandingAnimator((Interpolator)new OvershootInterpolator(1.0f)));
    }

    public RecyclerColumnsWithContentView(Context context) {
        super(context);
        this.init(null);
    }

    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public void setColumns(int number_columns) {
        this._columns = number_columns;
    }

    public int getColumns() {
        return this._columns;
    }

    public void addItemDecoration(RecyclerView.ItemDecoration decoration) {
        this._tmp_decorations.add(decoration);
        this._recycler.addItemDecoration(decoration);
    }

    public void setColumnsExpandedVisible(int number_columns_visible) {
        this._columns_left = number_columns_visible;
        int columns_right = this._columns - this._columns_left;
        ((LinearLayout.LayoutParams)this._left.getLayoutParams()).weight = this._columns_left;
        ((LinearLayout.LayoutParams)this._content.getLayoutParams()).weight = columns_right;
    }

    public int getColumnsExpandedVisible() {
        return this._columns_left;
    }

    public void setRecyclerAdapter(AbstractItemInflater provider) {
        this._recycler.setAdapter((RecyclerView.Adapter)MainArrayAdapter.instantiate(provider, this));
        if (provider.hasFooter()) {
            this._footer.removeAllViews();
            this._footer.addView(provider.getFooter((ViewGroup)this._footer));
            this._footer.requestLayout();
        }
        this.checkResume();
    }

    public void setRecyclerColumnsListener(IRecyclerColumnsListener listener) {
        this._listener = listener;
        this.checkResume();
    }

    public void showContent(final int position) {
        this.showContent();
        this.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (RecyclerColumnsWithContentView.this._recycler != null) {
                    RecyclerColumnsWithContentView.this._recycler.smoothScrollToPosition(position);
                }
            }
        }, 200L);
    }

    public void showContent() {
        if (this._recycler.getAdapter() != null && ((MainArrayAdapter)this._recycler.getAdapter()).isExpanded()) {
            ((MainArrayAdapter)this._recycler.getAdapter()).collapse();
            int footer_new_width = this._footer_parent.getWidth() * this._columns_left / this._columns;
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this._footer_parent.getWidth(), footer_new_width});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width = ((Float)animation.getAnimatedValue()).intValue();
                    RecyclerColumnsWithContentView.this._footer.requestLayout();
                    ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer_content.getLayoutParams().width = RecyclerColumnsWithContentView.this._footer_parent.getWidth() - ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width;
                    RecyclerColumnsWithContentView.this._footer_content.requestLayout();
                }
            });
            animator.start();
            this.invalidateDecorations();
            if (this._listener != null) {
                this._listener.onShowContent(this._content);
            }
        }
    }

    public void hideContent() {
        if (this._recycler.getAdapter() != null && !((MainArrayAdapter)this._recycler.getAdapter()).isExpanded()) {
            ((MainArrayAdapter)this._recycler.getAdapter()).expand();
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this._footer.getWidth(), this._footer_parent.getWidth()});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width = ((Float)animation.getAnimatedValue()).intValue();
                    RecyclerColumnsWithContentView.this._footer.requestLayout();
                    ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer_content.getLayoutParams().width = RecyclerColumnsWithContentView.this._footer_parent.getWidth() - ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width;
                    RecyclerColumnsWithContentView.this._footer_content.requestLayout();
                }
            });
            animator.start();
            this.invalidateDecorations();
            if (this._listener != null) {
                this._listener.onHideContent(this._content);
            }
        }
    }

    public boolean isShowingContent() {
        return this.isShowingContent(false);
    }

    public boolean isShowingContent(boolean with_temp) {
        if (with_temp && this.temporary_to_store_is_showing_content != null) {
            return this.temporary_to_store_is_showing_content;
        }
        return this.hasValidAdapter() && !((MainArrayAdapter)this._recycler.getAdapter()).isExpanded();
    }

    private boolean hasHeader() {
        if (this.hasValidAdapter()) {
            MainArrayAdapter adapter = (MainArrayAdapter)this._recycler.getAdapter();
            AbstractItem item = adapter.getItemAt(0);
            return item != null && item instanceof HeaderItem;
        }
        return false;
    }

    private boolean hasValidAdapter() {
        return this._recycler != null && this._recycler.getAdapter() != null && this._recycler.getAdapter() instanceof MainArrayAdapter;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.isShowingContent(false));
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state != null) {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.temporary_to_store_is_showing_content = savedState.isShowingContent();
            this.checkResume();
        }
    }

    public void checkResume() {
        if (this._recycler != null && this._recycler.getAdapter() != null && this._listener != null && this.temporary_to_store_is_showing_content != null) {
            if (this.temporary_to_store_is_showing_content.booleanValue()) {
                this.showContent();
            } else {
                this.hideContent();
            }
        }
    }

    private void invalidateDecorations() {
        try {
            if (this._tmp_decorations.size() > 0) {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (RecyclerView.ItemDecoration decoration : RecyclerColumnsWithContentView.this._tmp_decorations) {
                                RecyclerColumnsWithContentView.this._recycler.removeItemDecoration(decoration);
                                RecyclerColumnsWithContentView.this._recycler.addItemDecoration(decoration);
                            }
                            RecyclerColumnsWithContentView.this._recycler.postInvalidate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private Boolean is_showing_content = null;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, boolean is_showing_content) {
            super(superState);
            this.is_showing_content = is_showing_content;
        }

        private SavedState(Parcel in) {
            super(in);
            this.is_showing_content = in.readInt() == 1;
        }

        public Boolean isShowingContent() {
            return this.is_showing_content;
        }

        public void writeToParcel(Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeInt(this.is_showing_content != false ? 1 : 0);
        }
    }
}

