/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.recyclercolumnadaptable;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import eu.codlab.recyclercolumnadaptable.IRecyclerColumnsListener;
import eu.codlab.recyclercolumnadaptable.R;
import eu.codlab.recyclercolumnadaptable.inflater.AbstractItemInflater;
import eu.codlab.recyclercolumnadaptable.item.AbstractItem;
import eu.codlab.recyclercolumnadaptable.item.HeaderItem;
import eu.codlab.recyclercolumnadaptable.manager.GridLayoutSmoothManager;
import eu.codlab.recyclercolumnadaptable.states.SavedState;
import eu.codlab.recyclercolumnadaptable.view.MainArrayAdapter;
import java.util.ArrayList;
import java.util.List;
import jp.wasabeef.recyclerview.animators.LandingAnimator;

public class RecyclerColumnsWithContentView
extends FrameLayout
implements View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final long DELAY_INVALIDATE_DECORATIONS = 300L;
    private static final long DELAY_SET_SCROLL_POSITION = 300L;
    private static final int MINIMUM_COLUMNS_COUNT = 3;
    private static final int MINIMUM_COLUMNS_WHILE_BEING_EXPANDED_COUNT = 1;
    private int _columns_left = 0;
    private int _columns = 0;
    private RecyclerView _recycler;
    private ViewGroup _left;
    private ViewGroup _content;
    private IRecyclerColumnsListener _listener;
    private List<RecyclerView.ItemDecoration> _tmp_decorations = new ArrayList<RecyclerView.ItemDecoration>();
    private LinearLayout _footer_parent;
    private LinearLayout _footer;
    private LinearLayout _footer_content;
    private int _position_in_provider;
    private AbstractItemInflater _provider;
    private Boolean temporary_to_store_is_showing_content = null;

    private void init(AttributeSet attrs) {
        TypedArray array;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_recycler_columns, (ViewGroup)this, true);
        this._recycler = (RecyclerView)this.findViewById(R.id.recycler);
        this._left = (ViewGroup)this.findViewById(R.id.left);
        this._content = (ViewGroup)this.findViewById(R.id.content);
        this._footer = (LinearLayout)this.findViewById(R.id.footer);
        this._footer_parent = (LinearLayout)this.findViewById(R.id.footer_parent);
        this._footer_content = (LinearLayout)this.findViewById(R.id.content_footer);
        if (attrs != null && (array = this.getContext().obtainStyledAttributes(attrs, R.styleable.RecyclerColumnsWithContentView)) != null) {
            this._columns = array.getInteger(R.styleable.RecyclerColumnsWithContentView_columns, 3);
            this._columns_left = array.getInteger(R.styleable.RecyclerColumnsWithContentView_columnsVisibleExpanded, 1);
            this._columns = Math.max(this._columns, 3);
            this.setColumnsExpandedVisible(Math.max(this._columns_left, 1));
        }
        GridLayoutSmoothManager grid_manager = new GridLayoutSmoothManager(this.getContext(), this._columns);
        grid_manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int position) {
                return position == 0 && RecyclerColumnsWithContentView.this.hasHeader() ? RecyclerColumnsWithContentView.this.getColumns() : 1;
            }
        });
        this._recycler.setLayoutManager((RecyclerView.LayoutManager)grid_manager);
        this._recycler.setItemAnimator((RecyclerView.ItemAnimator)new LandingAnimator((Interpolator)new OvershootInterpolator(1.0f)));
        this._recycler.setOnTouchListener((View.OnTouchListener)this);
        this._position_in_provider = -1;
    }

    public RecyclerColumnsWithContentView(Context context) {
        super(context);
        this.init(null);
    }

    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public RecyclerColumnsWithContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    public void setColumns(int number_columns) {
        this._columns = number_columns;
    }

    public int getColumns() {
        return this._columns;
    }

    public void addItemDecoration(RecyclerView.ItemDecoration decoration) {
        this._tmp_decorations.add(decoration);
        this._recycler.addItemDecoration(decoration);
    }

    public void setColumnsExpandedVisible(int number_columns_visible) {
        this._columns_left = number_columns_visible;
        int columns_right = this._columns - this._columns_left;
        ((LinearLayout.LayoutParams)this._left.getLayoutParams()).weight = this._columns_left;
        ((LinearLayout.LayoutParams)this._content.getLayoutParams()).weight = columns_right;
    }

    public int getColumnsExpandedVisible() {
        return this._columns_left;
    }

    public void setRecyclerAdapter(AbstractItemInflater provider) {
        this._provider = provider;
        this._recycler.setAdapter((RecyclerView.Adapter)MainArrayAdapter.instantiate(provider, this));
        if (provider.hasFooter()) {
            this._footer.removeAllViews();
            this._footer.addView(provider.getFooter((ViewGroup)this._footer));
            this._footer.requestLayout();
        }
        this.checkResume();
    }

    public void setRecyclerColumnsListener(IRecyclerColumnsListener listener) {
        this._listener = listener;
        this.checkResume();
    }

    public boolean showContent(int position_in_item) {
        boolean shown_content = this.showContent();
        this._position_in_provider = position_in_item;
        if (shown_content) {
            this.updateScrollPositionToSelected();
            this.setSelectedItemIndex(-1);
        }
        return shown_content;
    }

    public boolean showContent() {
        boolean shown_content = this.showContentInternally();
        if (shown_content) {
            this.updateScrollPositionToSelected();
            this.setSelectedItemIndex(-1);
        }
        return shown_content;
    }

    private boolean showContentInternally() {
        boolean changed_state = false;
        if (this._recycler.getAdapter() != null) {
            if (((MainArrayAdapter)this._recycler.getAdapter()).isExpanded()) {
                changed_state = true;
                ((MainArrayAdapter)this._recycler.getAdapter()).collapse();
                int footer_new_width = this._footer_parent.getWidth() * this._columns_left / this._columns;
                this.updateFooter(this._footer_parent.getWidth(), footer_new_width);
            }
            this.invalidateDecorations();
            if (this._listener != null) {
                this._listener.onShowContent(this._content);
            }
        }
        return changed_state;
    }

    public boolean hideContent() {
        boolean changed_state = false;
        if (this._recycler.getAdapter() != null) {
            if (!((MainArrayAdapter)this._recycler.getAdapter()).isExpanded()) {
                changed_state = true;
                ((MainArrayAdapter)this._recycler.getAdapter()).expand();
                this.updateFooter(this._footer.getWidth(), this._footer_parent.getWidth());
                this.updateScrollPositionToSelected();
            }
            this.invalidateDecorations();
            if (this._listener != null) {
                this._listener.onHideContent(this._content);
            }
        }
        return changed_state;
    }

    public boolean isShowingContent() {
        return this.isShowingContent(false);
    }

    public boolean isShowingContent(boolean with_temp) {
        if (with_temp && this.temporary_to_store_is_showing_content != null) {
            return this.temporary_to_store_is_showing_content;
        }
        return this.hasValidAdapter() && !((MainArrayAdapter)this._recycler.getAdapter()).isExpanded();
    }

    private boolean hasHeader() {
        if (this.hasValidAdapter()) {
            MainArrayAdapter adapter = (MainArrayAdapter)this._recycler.getAdapter();
            AbstractItem item = adapter.getItemAt(0);
            return item != null && item instanceof HeaderItem;
        }
        return false;
    }

    private boolean hasValidAdapter() {
        return this._recycler != null && this._recycler.getAdapter() != null && this._recycler.getAdapter() instanceof MainArrayAdapter;
    }

    private void setSelectedItemIndex(int position_in_provider) {
        this._position_in_provider = position_in_provider;
    }

    private int getSelectedItemIndex() {
        return this._position_in_provider;
    }

    private void updateScrollPositionToSelected() {
        if (this.getSelectedItemIndex() >= 0 && this._provider != null && this.getSelectedItemIndex() < this._provider.getItemCount()) {
            final int position = ((MainArrayAdapter)this._recycler.getAdapter()).transformInArrayToPositionInRecycler(this.getSelectedItemIndex());
            Handler handler = this.getHandler();
            if (handler != null) {
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (RecyclerColumnsWithContentView.this._recycler != null) {
                            RecyclerColumnsWithContentView.this._recycler.smoothScrollToPosition(position);
                        }
                    }
                }, 300L);
            } else {
                this._recycler.scrollToPosition(position);
            }
        }
    }

    private void invalidateFooter() {
        if (this._provider != null && this._provider.hasFooter()) {
            if (((MainArrayAdapter)this._recycler.getAdapter()).isExpanded()) {
                this.updateFooter(this._footer.getWidth(), this._footer_parent.getWidth());
            } else {
                int footer_new_width = this._footer_parent.getWidth() * this._columns_left / this._columns;
                this.updateFooter(this._footer_parent.getWidth(), footer_new_width);
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }

    private void updateFooter(long from, long to) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width = ((Float)animation.getAnimatedValue()).intValue();
                RecyclerColumnsWithContentView.this._footer.requestLayout();
                ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer_content.getLayoutParams().width = RecyclerColumnsWithContentView.this._footer_parent.getWidth() - ((RecyclerColumnsWithContentView)RecyclerColumnsWithContentView.this)._footer.getLayoutParams().width;
                RecyclerColumnsWithContentView.this._footer_content.requestLayout();
            }
        });
        animator.start();
    }

    public void onGlobalLayout() {
        this.invalidateFooter();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.isShowingContent(false), this.getSelectedItemIndex());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state != null) {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.temporary_to_store_is_showing_content = savedState.isShowingContent();
            this.setSelectedItemIndex(savedState.getPositionInProvider());
            this.checkResume();
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void checkResume() {
        if (this._recycler != null && this._recycler.getAdapter() != null && this._listener != null) {
            if (this.temporary_to_store_is_showing_content != null) {
                if (this.temporary_to_store_is_showing_content.booleanValue()) {
                    if (this.getSelectedItemIndex() >= 0) {
                        this.showContent(this.getSelectedItemIndex());
                    } else {
                        this.showContent();
                    }
                } else {
                    this.hideContent();
                }
            }
            this.invalidateFooter();
        }
    }

    private void invalidateDecorations() {
        try {
            if (this._tmp_decorations.size() > 0) {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (RecyclerView.ItemDecoration decoration : RecyclerColumnsWithContentView.this._tmp_decorations) {
                                RecyclerColumnsWithContentView.this._recycler.removeItemDecoration(decoration);
                                RecyclerColumnsWithContentView.this._recycler.addItemDecoration(decoration);
                            }
                            RecyclerColumnsWithContentView.this._recycler.postInvalidate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, 300L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.setSelectedItemIndex(-1);
        return false;
    }
}

