/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.loader;

import eu.cloudnetservice.ext.platforminject.api.PlatformEntrypoint;
import eu.cloudnetservice.ext.platforminject.api.PlatformPluginManager;
import eu.cloudnetservice.ext.platforminject.api.spi.PlatformPluginManagerRegistry;
import eu.cloudnetservice.ext.platforminject.loader.PlatformInjectLoaderLazy;
import lombok.NonNull;

public final class PlatformInjectSupportLoader {
    private PlatformInjectSupportLoader() {
        throw new UnsupportedOperationException();
    }

    public static void loadPlugin(@NonNull String platform, @NonNull Class<? extends PlatformEntrypoint> pluginClass, @NonNull Object platformData, @NonNull ClassLoader platformClassLoader) {
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (pluginClass == null) {
            throw new NullPointerException("pluginClass is marked non-null but is null");
        }
        if (platformData == null) {
            throw new NullPointerException("platformData is marked non-null but is null");
        }
        if (platformClassLoader == null) {
            throw new NullPointerException("platformClassLoader is marked non-null but is null");
        }
        PlatformInjectLoaderLazy.ensureInitialized(platformClassLoader);
        PlatformPluginManager platformPluginManager = PlatformPluginManagerRegistry.registry().safeManager(platform);
        platformPluginManager.constructAndLoad(pluginClass, platformData);
    }

    public static void disablePlugin(@NonNull String platform, @NonNull Object platformData) {
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (platformData == null) {
            throw new NullPointerException("platformData is marked non-null but is null");
        }
        if (PlatformInjectLoaderLazy.loader != null) {
            PlatformPluginManager platformPluginManager = PlatformPluginManagerRegistry.registry().safeManager(platform);
            platformPluginManager.disablePlugin(platformData);
        }
    }
}

