/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.loader;

import eu.cloudnetservice.ext.platforminject.api.registry.PlatformManagerRegistryHolder;
import eu.cloudnetservice.ext.platforminject.loader.JarInJarClassLoader;
import java.net.URL;
import lombok.NonNull;

final class PlatformInjectLoaderLazy {
    private static final String SUPPORT_JAR_NAME = "platform-inject-support.jar";
    static ClassLoader loader;

    PlatformInjectLoaderLazy() {
    }

    public static void ensureInitialized(@NonNull ClassLoader parentLoader) {
        if (parentLoader == null) {
            throw new NullPointerException("parentLoader is marked non-null but is null");
        }
        if (loader == null) {
            URL loaderJar = PlatformInjectLoaderLazy.class.getClassLoader().getResource(SUPPORT_JAR_NAME);
            if (loaderJar == null) {
                throw new IllegalStateException("Loader jar is missing, invalid compile?");
            }
            JarInJarClassLoader internalLoader = new JarInJarClassLoader("inject-support", loaderJar, parentLoader);
            if (loader == null) {
                loader = internalLoader;
                PlatformManagerRegistryHolder.init((ClassLoader)internalLoader);
            }
        }
    }
}

