/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.loader;

import eu.cloudnetservice.common.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import lombok.NonNull;

final class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(@NonNull String name, @NonNull URL internalJarUrl, @NonNull ClassLoader parent) {
        super(name, JarInJarClassLoader.extractJar(internalJarUrl), parent);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (internalJarUrl == null) {
            throw new NullPointerException("internalJarUrl is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
    }

    @NonNull
    private static URL[] extractJar(@NonNull URL internalJarUrl) {
        URL[] uRLArray;
        block9: {
            if (internalJarUrl == null) {
                throw new NullPointerException("internalJarUrl is marked non-null but is null");
            }
            Path target = Path.of(".inject", "inject-support.jar");
            InputStream stream = internalJarUrl.openStream();
            try {
                FileUtil.copy((InputStream)stream, (Path)target);
                uRLArray = new URL[]{target.toUri().toURL()};
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Unable to extract jar in jar for inject support", exception);
                }
            }
            stream.close();
        }
        return uRLArray;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

