/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.spi;

import eu.cloudnetservice.common.Named;
import eu.cloudnetservice.ext.platforminject.api.PlatformPluginManager;
import eu.cloudnetservice.ext.platforminject.api.util.FunctionalUtil;
import java.util.function.Supplier;
import lombok.NonNull;

public class PlatformPluginManagerProvider<I, T>
implements Named {
    private final String name;
    private final Supplier<PlatformPluginManager<I, T>> managerProvider;

    public PlatformPluginManagerProvider(@NonNull String name, @NonNull Supplier<PlatformPluginManager<I, T>> managerProvider) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (managerProvider == null) {
            throw new NullPointerException("managerProvider is marked non-null but is null");
        }
        this.name = name;
        this.managerProvider = FunctionalUtil.memoizing(managerProvider);
    }

    @NonNull
    public PlatformPluginManager<I, T> provideManager() {
        return this.managerProvider.get();
    }

    @NonNull
    public String name() {
        return this.name;
    }
}

