/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.data;

import eu.cloudnetservice.ext.platforminject.api.data.ParsedPluginData;
import eu.cloudnetservice.ext.platforminject.api.stereotype.Command;
import eu.cloudnetservice.ext.platforminject.api.stereotype.Dependency;
import eu.cloudnetservice.ext.platforminject.api.stereotype.ExternalDependency;
import eu.cloudnetservice.ext.platforminject.api.stereotype.PlatformPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class PluginDataParser {
    public static final int PLUGIN_COMMANDS = 1;
    public static final int PLUGIN_DEPENDENCIES = 2;
    public static final int EXTERNAL_DEPENDENCIES = 4;
    public static final int EXTERNAL_REPOSITORIES = 8;
    private int supportedPlatformComponents;

    private PluginDataParser() {
    }

    @NonNull
    public static PluginDataParser create() {
        return new PluginDataParser();
    }

    @NonNull
    private static String validateName(@NonNull String name, @NonNull String type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name.isBlank()) {
            throw new IllegalArgumentException("Invalid name for " + type + ": \"" + name + "\" must not be blank");
        }
        return name;
    }

    @Nullable
    private static String normalizeValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.isBlank() ? null : value;
    }

    @NonNull
    public PluginDataParser enableSupport(int flag) {
        this.supportedPlatformComponents |= flag;
        return this;
    }

    @NonNull
    public ParsedPluginData parseAndValidateData(@NonNull PlatformPlugin plugin, @Nullable String listener) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        String name = PluginDataParser.validateName(plugin.name(), "name");
        String version = PluginDataParser.validateName(plugin.version(), "version");
        String api = PluginDataParser.normalizeValue(plugin.api());
        String homepage = PluginDataParser.normalizeValue(plugin.homepage());
        String desc = PluginDataParser.normalizeValue(plugin.description());
        List<String> authors = Arrays.stream(plugin.authors()).filter(s -> !s.isBlank()).distinct().toList();
        List<Dependency> deps = this.hasFlag(2) ? Arrays.stream(plugin.dependencies()).filter(dep -> !dep.name().isBlank()).toList() : List.of();
        List<Command> commands = this.hasFlag(1) ? Arrays.stream(plugin.commands()).filter(cmd -> !cmd.name().isBlank()).toList() : List.of();
        List<String> pluginFileNames = Arrays.stream(plugin.pluginFileNames()).filter(fileName -> !name.isBlank()).toList();
        if (!this.hasFlag(4)) {
            return new ParsedPluginData(name, version, api, desc, homepage, listener, authors, commands, pluginFileNames, deps, List.of());
        }
        HashSet<ExternalDependency> externalDeps = new HashSet<ExternalDependency>();
        for (ExternalDependency dependency : plugin.externalDependencies()) {
            PluginDataParser.validateName(dependency.version(), "dependency version");
            PluginDataParser.validateName(dependency.groupId(), "dependency group id");
            PluginDataParser.validateName(dependency.artifactId(), "dependency artifact id");
            if (this.hasFlag(8)) {
                PluginDataParser.validateName(dependency.repository().id(), "repository id");
                PluginDataParser.validateName(dependency.repository().url(), "repository url");
            }
            externalDeps.add(dependency);
        }
        return new ParsedPluginData(name, version, api, desc, homepage, listener, authors, commands, pluginFileNames, deps, externalDeps);
    }

    private boolean hasFlag(int flag) {
        return (this.supportedPlatformComponents & flag) != 0;
    }
}

