/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.platforminject.api.spi;

import eu.cloudnetservice.ext.platforminject.api.data.PluginDataParser;
import eu.cloudnetservice.ext.platforminject.api.generator.PlatformMainClassGenerator;
import eu.cloudnetservice.ext.platforminject.api.generator.PluginInfoGenerator;
import eu.cloudnetservice.ext.platforminject.api.util.FunctionalUtil;
import java.util.function.Supplier;
import lombok.NonNull;

public class PlatformDataGeneratorProvider {
    private final String name;
    private final Supplier<PluginDataParser> pluginDataParser;
    private final Supplier<PluginInfoGenerator> infoGenerator;
    private final Supplier<PlatformMainClassGenerator> mainClassGenerator;

    public PlatformDataGeneratorProvider(@NonNull String name, @NonNull Supplier<PluginInfoGenerator> infoGenerator, @NonNull Supplier<PlatformMainClassGenerator> mainClassGenerator, @NonNull Supplier<PluginDataParser> pluginDataParser) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (infoGenerator == null) {
            throw new NullPointerException("infoGenerator is marked non-null but is null");
        }
        if (mainClassGenerator == null) {
            throw new NullPointerException("mainClassGenerator is marked non-null but is null");
        }
        if (pluginDataParser == null) {
            throw new NullPointerException("pluginDataParser is marked non-null but is null");
        }
        this.name = name;
        this.pluginDataParser = FunctionalUtil.memoizing(pluginDataParser);
        this.infoGenerator = FunctionalUtil.memoizing(infoGenerator);
        this.mainClassGenerator = FunctionalUtil.memoizing(mainClassGenerator);
    }

    @NonNull
    public PluginDataParser dataParser() {
        return this.pluginDataParser.get();
    }

    @NonNull
    public PluginInfoGenerator infoGenerator() {
        return this.infoGenerator.get();
    }

    @NonNull
    public PlatformMainClassGenerator mainClassGenerator() {
        return this.mainClassGenerator.get();
    }

    @NonNull
    public String name() {
        return this.name;
    }
}

