/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.ext.modlauncher;

import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import lombok.NonNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class CloudNetLaunchPluginService
implements ILaunchPluginService {
    private static final Collection<String> EXCLUDED_PACKAGE_STARTS = Arrays.asList("eu.cloudnetservice.wrapper.", "eu.cloudnetservice.common.", "eu.cloudnetservice.driver.");

    @NonNull
    public String name() {
        return "wrapper-tweaker";
    }

    @NonNull
    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType) {
        return false;
    }

    public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader, Path[] specialPaths) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof TransformingClassLoader)) {
            throw new IllegalStateException("Thread context class loader should be an instance of TransformingClassLoader");
        }
        TransformingClassLoader loader = (TransformingClassLoader)classLoader;
        loader.addTargetPackageFilter(pkg -> EXCLUDED_PACKAGE_STARTS.stream().noneMatch(pkg::startsWith));
    }
}

