/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util.define;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import eu.cloudnetservice.driver.util.define.ClassDefiner;
import java.time.Duration;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FallbackClassDefiner
implements ClassDefiner {
    private final LoadingCache<ClassLoader, DefiningClassLoader> cache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).build(DefiningClassLoader::new);

    FallbackClassDefiner() {
    }

    @Override
    @NonNull
    public Class<?> defineClass(@NonNull String name, @NonNull Class<?> parent, byte[] bytecode) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        return ((DefiningClassLoader)this.cache.get((Object)parent.getClassLoader())).defineClass(bytecode);
    }

    private static final class DefiningClassLoader
    extends ClassLoader {
        public DefiningClassLoader(@Nullable ClassLoader parent) {
            super(parent);
        }

        @NonNull
        public Class<?> defineClass(byte[] byteCode) {
            return super.defineClass(null, byteCode, 0, byteCode.length, null);
        }
    }
}

