/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util.asm;

import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@ApiStatus.Internal
public final class StackIndexHelper {
    private int nextVarIndex;

    private StackIndexHelper(int initialVarIndex) {
        this.nextVarIndex = initialVarIndex;
    }

    @NonNull
    public static StackIndexHelper create() {
        return StackIndexHelper.create(0);
    }

    @NonNull
    public static StackIndexHelper create(int initialVarIndex) {
        return new StackIndexHelper(initialVarIndex);
    }

    @NonNull
    public StackIndexHelper skipNext() {
        return this.skip(1);
    }

    @NonNull
    public StackIndexHelper skip(int depth) {
        this.nextVarIndex += depth;
        return this;
    }

    @NonNull
    public StackIndexHelper push(@NonNull MethodVisitor methodVisitor, @NonNull Class<?> type) {
        if (methodVisitor == null) {
            throw new NullPointerException("methodVisitor is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Type internalType = Type.getType(type);
        return this.push(methodVisitor, internalType);
    }

    @NonNull
    public StackIndexHelper push(@NonNull MethodVisitor methodVisitor, @NonNull Type type) {
        if (methodVisitor == null) {
            throw new NullPointerException("methodVisitor is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        int opcode = type.getOpcode(54);
        methodVisitor.visitVarInsn(opcode, this.nextVarIndex);
        return this.skip(type.getSize());
    }

    @NonNull
    public StackIndexHelper load(@NonNull MethodVisitor methodVisitor, @NonNull Class<?> type) {
        if (methodVisitor == null) {
            throw new NullPointerException("methodVisitor is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Type internalType = Type.getType(type);
        return this.load(methodVisitor, internalType);
    }

    @NonNull
    public StackIndexHelper load(@NonNull MethodVisitor methodVisitor, @NonNull Type type) {
        if (methodVisitor == null) {
            throw new NullPointerException("methodVisitor is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        int opcode = type.getOpcode(21);
        methodVisitor.visitVarInsn(opcode, this.nextVarIndex);
        return this.skip(type.getSize());
    }
}

