/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.derklaro.reflexion.MethodAccessor;
import dev.derklaro.reflexion.Reflexion;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ExecutorServiceUtil {
    private static final boolean VIRTUAL_THREADS_AVAILABLE;
    private static final MethodAccessor<Method> VIRTUAL_BUILDER_GETTER;
    private static final MethodAccessor<Method> VIRTUAL_BUILDER_NAME;
    private static final MethodAccessor<Method> VIRTUAL_BUILDER_TO_FACTORY;
    private static final MethodAccessor<Method> EXECUTORS_NEW_THREAD_PER_TASK;

    private ExecutorServiceUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean virtualThreadsAvailable() {
        return VIRTUAL_THREADS_AVAILABLE;
    }

    @NonNull
    public static ExecutorService newVirtualThreadExecutor(@NonNull String threadNamePrefix, @NonNull Function<ThreadFactory, ExecutorService> fallbackExecutorFactory) {
        if (threadNamePrefix == null) {
            throw new NullPointerException("threadNamePrefix is marked non-null but is null");
        }
        if (fallbackExecutorFactory == null) {
            throw new NullPointerException("fallbackExecutorFactory is marked non-null but is null");
        }
        if (VIRTUAL_THREADS_AVAILABLE) {
            return (ExecutorService)VIRTUAL_BUILDER_GETTER.invoke().flatMap(builder -> VIRTUAL_BUILDER_NAME.invoke(builder, new Object[]{threadNamePrefix, 1L})).flatMap(arg_0 -> VIRTUAL_BUILDER_TO_FACTORY.invoke(arg_0)).flatMap(xva$0 -> EXECUTORS_NEW_THREAD_PER_TASK.invokeWithArgs(new Object[]{xva$0})).getOrThrow();
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "%d").setThreadFactory(Executors.defaultThreadFactory()).build();
        return fallbackExecutorFactory.apply(threadFactory);
    }

    static {
        Reflexion threadReflexion = Reflexion.on(Thread.class);
        VIRTUAL_BUILDER_GETTER = threadReflexion.findMethod("ofVirtual", new Class[0]).orElse(null);
        if (VIRTUAL_BUILDER_GETTER == null || VIRTUAL_BUILDER_GETTER.invoke().wasExceptional()) {
            VIRTUAL_THREADS_AVAILABLE = false;
            VIRTUAL_BUILDER_NAME = null;
            VIRTUAL_BUILDER_TO_FACTORY = null;
            EXECUTORS_NEW_THREAD_PER_TASK = null;
        } else {
            VIRTUAL_THREADS_AVAILABLE = true;
            Reflexion virtualBuilderReflexion = (Reflexion)Reflexion.find((String)"java.lang.Thread$Builder$OfVirtual").orElseThrow();
            VIRTUAL_BUILDER_NAME = (MethodAccessor)virtualBuilderReflexion.findMethod("name", new Class[]{String.class, Long.TYPE}).orElseThrow();
            VIRTUAL_BUILDER_TO_FACTORY = (MethodAccessor)virtualBuilderReflexion.findMethod("factory", new Class[0]).orElseThrow();
            Reflexion executorsReflexion = Reflexion.on(Executors.class);
            EXECUTORS_NEW_THREAD_PER_TASK = (MethodAccessor)executorsReflexion.findMethod("newThreadPerTaskExecutor", new Class[]{ThreadFactory.class}).orElseThrow();
        }
    }
}

