/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.document.property.DocProperty;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.NonNull;

public final class ServiceRemoteInclusion
implements DefaultedDocPropertyHolder,
Cloneable {
    public static final DocProperty<Map<String, String>> HEADERS = DocProperty.genericProperty("headers", TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{String.class, String.class}));
    private final String url;
    private final String destination;
    private final Document properties;

    private ServiceRemoteInclusion(@NonNull String url, @NonNull String destination, @NonNull Document properties) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.url = url;
        this.destination = destination;
        this.properties = properties;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull ServiceRemoteInclusion inclusion) {
        if (inclusion == null) {
            throw new NullPointerException("inclusion is marked non-null but is null");
        }
        return ServiceRemoteInclusion.builder().url(inclusion.url()).destination(inclusion.destination()).properties(inclusion.propertyHolder());
    }

    @NonNull
    public String url() {
        return this.url;
    }

    @NonNull
    public String destination() {
        return this.destination;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    @NonNull
    public String toString() {
        return this.url + ":" + this.destination;
    }

    @NonNull
    public ServiceRemoteInclusion clone() {
        try {
            return (ServiceRemoteInclusion)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceRemoteInclusion)) {
            return false;
        }
        ServiceRemoteInclusion other = (ServiceRemoteInclusion)o;
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$destination = this.destination;
        String other$destination = other.destination;
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $destination = this.destination;
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public static class Builder {
        protected String url;
        protected String destination;
        protected Document properties = Document.emptyDocument();

        @NonNull
        public Builder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @NonNull
        public Builder destination(@NonNull String destination) {
            if (destination == null) {
                throw new NullPointerException("destination is marked non-null but is null");
            }
            this.destination = destination;
            return this;
        }

        @NonNull
        public Builder properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.immutableCopy();
            return this;
        }

        @NonNull
        public ServiceRemoteInclusion build() {
            Preconditions.checkNotNull((Object)this.url, (Object)"no url given");
            Preconditions.checkNotNull((Object)this.destination, (Object)"no destination given");
            return new ServiceRemoteInclusion(this.url, this.destination, this.properties);
        }
    }
}

