/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.registry;

import com.google.common.collect.Iterables;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import java.util.Collection;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.UnmodifiableView;

public interface ServiceRegistry {
    @Deprecated(since="4.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="4.1")
    public static <T> @UnknownNullability T first(@NonNull Class<T> service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        ServiceRegistry registry = InjectionLayer.boot().instance(ServiceRegistry.class);
        return registry.firstProvider(service);
    }

    @NonNull
    public <T, E extends T> ServiceRegistry registerProvider(@NonNull Class<T> var1, @NonNull String var2, @NonNull E var3);

    @NonNull
    public <T, E extends T> ServiceRegistry unregisterProvider(@NonNull Class<T> var1, @NonNull Class<E> var2);

    @NonNull
    public <T, E extends T> ServiceRegistry unregisterProvider(@NonNull Class<T> var1, @NonNull E var2);

    public <T> boolean hasProvider(@NonNull Class<T> var1, @NonNull String var2);

    @NonNull
    public <T> ServiceRegistry unregisterProvider(@NonNull Class<T> var1, @NonNull String var2);

    @NonNull
    public <T> ServiceRegistry unregisterProviders(@NonNull Class<T> var1);

    @NonNull
    public ServiceRegistry unregisterAll();

    @NonNull
    public ServiceRegistry unregisterAll(@NonNull ClassLoader var1);

    @NonNull
    public Collection<Class<?>> providedServices();

    public <T> @UnknownNullability T provider(@NonNull Class<T> var1, @NonNull String var2);

    default public <T> @UnknownNullability T firstProvider(@NonNull Class<T> service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return (T)Iterables.getFirst(this.providers(service), null);
    }

    public <T> @UnmodifiableView @NonNull Collection<T> providers(@NonNull Class<T> var1);
}

