/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.derklaro.aerogel.auto.Provides;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.registry.injection.Service;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

@Singleton
@Provides(value={ServiceRegistry.class})
public class DefaultServiceRegistry
implements ServiceRegistry {
    protected final Multimap<Class<?>, RegistryEntry<?>> providers = Multimaps.newMultimap(new ConcurrentHashMap(), ConcurrentHashMap::newKeySet);

    @Inject
    public DefaultServiceRegistry(@NonNull InjectionLayer<?> injectionLayer) {
        if (injectionLayer == null) {
            throw new NullPointerException("injectionLayer is marked non-null but is null");
        }
        BindingConstructor bindingConstructor = BindingBuilder.create().bindMatching(element -> {
            if (element.hasSpecialRequirements()) {
                return element.requiredAnnotations().stream().anyMatch(predicate -> predicate.annotationType().equals(Service.class));
            }
            return false;
        }).toLazyProvider((element, $) -> () -> element.requiredAnnotations().stream().filter(predicate -> predicate.annotationType().equals(Service.class)).findFirst().map(annotationPredicate -> {
            Map annotationValues = annotationPredicate.annotationValues();
            Class serviceClass = TypeUtil.rawType((Type)element.componentType());
            String serviceName = (String)annotationValues.get("name");
            if (serviceName.isEmpty()) {
                return this.firstProvider(serviceClass);
            }
            return this.provider(serviceClass, serviceName);
        }).orElse(null));
        injectionLayer.install(bindingConstructor);
    }

    @Override
    @NonNull
    public <T, E extends T> ServiceRegistry registerProvider(@NonNull Class<T> service, @NonNull String name, @NonNull E provider) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.providers.put(service, new RegistryEntry<E>(name, provider));
        return this;
    }

    @Override
    @NonNull
    public <T, E extends T> ServiceRegistry unregisterProvider(@NonNull Class<T> service, @NonNull Class<E> provider) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        Collection providers = this.providers.get(service);
        if (!providers.isEmpty()) {
            providers.removeIf(entry -> entry.provider().getClass().isAssignableFrom(provider));
        }
        return this;
    }

    @Override
    @NonNull
    public <T, E extends T> ServiceRegistry unregisterProvider(@NonNull Class<T> service, @NonNull E provider) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        Collection providers = this.providers.get(service);
        if (!providers.isEmpty()) {
            providers.removeIf(entry -> entry.provider().equals(provider));
        }
        return this;
    }

    @Override
    public <T> boolean hasProvider(@NonNull Class<T> clazz, @NonNull String name) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.providers.get(clazz).stream().anyMatch(entry -> entry.name().equals(name));
    }

    @Override
    @NonNull
    public <T> ServiceRegistry unregisterProvider(@NonNull Class<T> service, @NonNull String name) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Collection providers = this.providers.get(service);
        if (!providers.isEmpty()) {
            providers.removeIf(entry -> entry.name().equals(name));
        }
        return this;
    }

    @Override
    @NonNull
    public <T> ServiceRegistry unregisterProviders(@NonNull Class<T> service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        this.providers.removeAll(service);
        return this;
    }

    @Override
    @NonNull
    public ServiceRegistry unregisterAll() {
        this.providers.clear();
        return this;
    }

    @Override
    @NonNull
    public ServiceRegistry unregisterAll(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        for (Map.Entry entry : this.providers.entries()) {
            if (!((RegistryEntry)entry.getValue()).provider().getClass().getClassLoader().equals(classLoader)) continue;
            this.providers.remove(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    @NonNull
    public Collection<Class<?>> providedServices() {
        return Collections.unmodifiableCollection(this.providers.keySet());
    }

    @Override
    public <T> T provider(@NonNull Class<T> service, @NonNull String name) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.providers.get(service).stream().filter(entry -> entry.name().equals(name)).map(entry -> entry.provider()).findFirst().orElse(null);
    }

    @Override
    @NonNull
    public <T> Collection<T> providers(@NonNull Class<T> service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return this.providers.get(service).stream().map(entry -> entry.provider()).toList();
    }

    private record RegistryEntry<T>(@NonNull String name, @NonNull T provider) {
        public RegistryEntry(@NonNull String name, @NonNull T provider) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (provider == null) {
                throw new NullPointerException("provider is marked non-null but is null");
            }
        }
    }
}

