/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import eu.cloudnetservice.driver.provider.SpecificCloudServiceProvider;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import java.util.Collection;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@RPCValidation
public interface CloudServiceProvider {
    @NonNull
    public SpecificCloudServiceProvider serviceProvider(@NonNull UUID var1);

    @NonNull
    public SpecificCloudServiceProvider serviceProviderByName(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> services();

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> runningServices();

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByTask(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByEnvironment(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<ServiceInfoSnapshot> servicesByGroup(@NonNull String var1);

    public int serviceCount();

    public int serviceCountByGroup(@NonNull String var1);

    public int serviceCountByTask(@NonNull String var1);

    @Nullable
    public ServiceInfoSnapshot serviceByName(@NonNull String var1);

    @Nullable
    public ServiceInfoSnapshot service(@NonNull UUID var1);

    @NonNull
    default public Task<Collection<ServiceInfoSnapshot>> servicesAsync() {
        return Task.supply(this::services);
    }

    @NonNull
    default public Task<Collection<ServiceInfoSnapshot>> runningServicesAsync() {
        return Task.supply(this::runningServices);
    }

    @NonNull
    default public Task<Collection<ServiceInfoSnapshot>> servicesByTaskAsync(@NonNull String taskName) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        return Task.supply(() -> this.servicesByTask(taskName));
    }

    @NonNull
    default public Task<Collection<ServiceInfoSnapshot>> servicesByEnvironmentAsync(@NonNull String environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return Task.supply(() -> this.servicesByEnvironment(environment));
    }

    @NonNull
    default public Task<Collection<ServiceInfoSnapshot>> servicesByGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return Task.supply(() -> this.servicesByGroup(group));
    }

    @NonNull
    default public Task<Integer> serviceCountAsync() {
        return Task.supply(this::serviceCount);
    }

    @NonNull
    default public Task<Integer> serviceCountByGroupAsync(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return Task.supply(() -> this.serviceCountByGroup(group));
    }

    @NonNull
    default public Task<Integer> serviceCountByTaskAsync(@NonNull String taskName) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        return Task.supply(() -> this.serviceCountByTask(taskName));
    }

    @NonNull
    default public Task<ServiceInfoSnapshot> serviceByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Task.supply(() -> this.serviceByName(name));
    }

    @NonNull
    default public Task<ServiceInfoSnapshot> serviceAsync(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Task.supply(() -> this.service(uniqueId));
    }
}

