/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.permission;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class PermissionUserGroupInfo
implements DefaultedDocPropertyHolder {
    private final String group;
    private final long timeOutMillis;
    private final Document properties;

    protected PermissionUserGroupInfo(@NonNull String group, long timeOutMillis, @NonNull Document properties) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.group = group;
        this.timeOutMillis = timeOutMillis;
        this.properties = properties;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull PermissionUserGroupInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return PermissionUserGroupInfo.builder().group(info.group()).timeOutMillis(info.timeOutMillis()).properties(info.propertyHolder());
    }

    @NonNull
    public String group() {
        return this.group;
    }

    public long timeOutMillis() {
        return this.timeOutMillis;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    public String toString() {
        return "PermissionUserGroupInfo(group=" + this.group + ", timeOutMillis=" + this.timeOutMillis + ", properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermissionUserGroupInfo)) {
            return false;
        }
        PermissionUserGroupInfo other = (PermissionUserGroupInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.timeOutMillis != other.timeOutMillis) {
            return false;
        }
        String this$group = this.group;
        String other$group = other.group;
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PermissionUserGroupInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeOutMillis = this.timeOutMillis;
        result = result * 59 + (int)($timeOutMillis >>> 32 ^ $timeOutMillis);
        String $group = this.group;
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public static final class Builder {
        private String group;
        private long timeOutMillis = 0L;
        private Document properties = Document.emptyDocument();

        @NonNull
        public Builder group(@NonNull String group) {
            if (group == null) {
                throw new NullPointerException("group is marked non-null but is null");
            }
            this.group = group;
            return this;
        }

        @NonNull
        public Builder timeOutMillis(long timeOutMillis) {
            this.timeOutMillis = timeOutMillis;
            return this;
        }

        @NonNull
        public Builder timeOut(long timeout, @NonNull TimeUnit unit) {
            if (unit == null) {
                throw new NullPointerException("unit is marked non-null but is null");
            }
            return this.timeOutMillis(System.currentTimeMillis() + unit.toMillis(timeout));
        }

        @NonNull
        public Builder timeOut(@NonNull Duration duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            return this.timeOutMillis(System.currentTimeMillis() + duration.toMillis());
        }

        @NonNull
        public Builder properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.immutableCopy();
            return this;
        }

        @NonNull
        public PermissionUserGroupInfo build() {
            Preconditions.checkNotNull((Object)this.group, (Object)"Missing group");
            return new PermissionUserGroupInfo(this.group, this.timeOutMillis, this.properties);
        }
    }
}

